/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codecommit.model.RepositoryTrigger;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class RepositoryTriggerJsonMarshaller {
    private static RepositoryTriggerJsonMarshaller instance;

    public void marshall(RepositoryTrigger repositoryTrigger, JSONWriter jsonWriter) {
        if (repositoryTrigger == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> eventsList;
            List<String> branchesList;
            jsonWriter.object();
            if (repositoryTrigger.getName() != null) {
                jsonWriter.key("name").value(repositoryTrigger.getName());
            }
            if (repositoryTrigger.getDestinationArn() != null) {
                jsonWriter.key("destinationArn").value(repositoryTrigger.getDestinationArn());
            }
            if (repositoryTrigger.getCustomData() != null) {
                jsonWriter.key("customData").value(repositoryTrigger.getCustomData());
            }
            if ((branchesList = repositoryTrigger.getBranches()) != null) {
                jsonWriter.key("branches");
                jsonWriter.array();
                for (String branchesListValue : branchesList) {
                    if (branchesListValue == null) continue;
                    jsonWriter.value(branchesListValue);
                }
                jsonWriter.endArray();
            }
            if ((eventsList = repositoryTrigger.getEvents()) != null) {
                jsonWriter.key("events");
                jsonWriter.array();
                for (String eventsListValue : eventsList) {
                    if (eventsListValue == null) continue;
                    jsonWriter.value(eventsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RepositoryTriggerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RepositoryTriggerJsonMarshaller();
        }
        return instance;
    }
}

