/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.RepositoryTrigger;
import com.amazonaws.services.codecommit.model.transform.RepositoryTriggerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class PutRepositoryTriggersRequestMarshaller
implements Marshaller<Request<PutRepositoryTriggersRequest>, PutRepositoryTriggersRequest> {
    @Override
    public Request<PutRepositoryTriggersRequest> marshall(PutRepositoryTriggersRequest putRepositoryTriggersRequest) {
        if (putRepositoryTriggersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutRepositoryTriggersRequest> request = new DefaultRequest<PutRepositoryTriggersRequest>(putRepositoryTriggersRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.PutRepositoryTriggers");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<RepositoryTrigger> triggersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putRepositoryTriggersRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(putRepositoryTriggersRequest.getRepositoryName());
            }
            if ((triggersList = putRepositoryTriggersRequest.getTriggers()) != null) {
                jsonWriter.key("triggers");
                jsonWriter.array();
                for (RepositoryTrigger triggersListValue : triggersList) {
                    if (triggersListValue == null) continue;
                    RepositoryTriggerJsonMarshaller.getInstance().marshall(triggersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

