/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.Architecture;
import com.amazonaws.services.opsworks.model.AutoScalingType;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.ReportedOs;
import com.amazonaws.services.opsworks.model.RootDeviceType;
import com.amazonaws.services.opsworks.model.VirtualizationType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Instance
implements Serializable,
Cloneable {
    private String agentVersion;
    private String amiId;
    private String architecture;
    private String autoScalingType;
    private String availabilityZone;
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private String createdAt;
    private Boolean ebsOptimized;
    private String ec2InstanceId;
    private String ecsClusterArn;
    private String ecsContainerInstanceArn;
    private String elasticIp;
    private String hostname;
    private String infrastructureClass;
    private Boolean installUpdatesOnBoot;
    private String instanceId;
    private String instanceProfileArn;
    private String instanceType;
    private String lastServiceErrorId;
    private SdkInternalList<String> layerIds;
    private String os;
    private String platform;
    private String privateDns;
    private String privateIp;
    private String publicDns;
    private String publicIp;
    private String registeredBy;
    private String reportedAgentVersion;
    private ReportedOs reportedOs;
    private String rootDeviceType;
    private String rootDeviceVolumeId;
    private SdkInternalList<String> securityGroupIds;
    private String sshHostDsaKeyFingerprint;
    private String sshHostRsaKeyFingerprint;
    private String sshKeyName;
    private String stackId;
    private String status;
    private String subnetId;
    private String virtualizationType;

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public Instance withAgentVersion(String agentVersion) {
        this.setAgentVersion(agentVersion);
        return this;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public Instance withAmiId(String amiId) {
        this.setAmiId(amiId);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public Instance withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
    }

    public Instance withArchitecture(Architecture architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setAutoScalingType(String autoScalingType) {
        this.autoScalingType = autoScalingType;
    }

    public String getAutoScalingType() {
        return this.autoScalingType;
    }

    public Instance withAutoScalingType(String autoScalingType) {
        this.setAutoScalingType(autoScalingType);
        return this;
    }

    public void setAutoScalingType(AutoScalingType autoScalingType) {
        this.autoScalingType = autoScalingType.toString();
    }

    public Instance withAutoScalingType(AutoScalingType autoScalingType) {
        this.setAutoScalingType(autoScalingType);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Instance withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings);
    }

    public Instance withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public Instance withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Instance withCreatedAt(String createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public Instance withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
    }

    public String getEc2InstanceId() {
        return this.ec2InstanceId;
    }

    public Instance withEc2InstanceId(String ec2InstanceId) {
        this.setEc2InstanceId(ec2InstanceId);
        return this;
    }

    public void setEcsClusterArn(String ecsClusterArn) {
        this.ecsClusterArn = ecsClusterArn;
    }

    public String getEcsClusterArn() {
        return this.ecsClusterArn;
    }

    public Instance withEcsClusterArn(String ecsClusterArn) {
        this.setEcsClusterArn(ecsClusterArn);
        return this;
    }

    public void setEcsContainerInstanceArn(String ecsContainerInstanceArn) {
        this.ecsContainerInstanceArn = ecsContainerInstanceArn;
    }

    public String getEcsContainerInstanceArn() {
        return this.ecsContainerInstanceArn;
    }

    public Instance withEcsContainerInstanceArn(String ecsContainerInstanceArn) {
        this.setEcsContainerInstanceArn(ecsContainerInstanceArn);
        return this;
    }

    public void setElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
    }

    public String getElasticIp() {
        return this.elasticIp;
    }

    public Instance withElasticIp(String elasticIp) {
        this.setElasticIp(elasticIp);
        return this;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Instance withHostname(String hostname) {
        this.setHostname(hostname);
        return this;
    }

    public void setInfrastructureClass(String infrastructureClass) {
        this.infrastructureClass = infrastructureClass;
    }

    public String getInfrastructureClass() {
        return this.infrastructureClass;
    }

    public Instance withInfrastructureClass(String infrastructureClass) {
        this.setInfrastructureClass(infrastructureClass);
        return this;
    }

    public void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
    }

    public Boolean getInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Instance withInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.setInstallUpdatesOnBoot(installUpdatesOnBoot);
        return this;
    }

    public Boolean isInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Instance withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setInstanceProfileArn(String instanceProfileArn) {
        this.instanceProfileArn = instanceProfileArn;
    }

    public String getInstanceProfileArn() {
        return this.instanceProfileArn;
    }

    public Instance withInstanceProfileArn(String instanceProfileArn) {
        this.setInstanceProfileArn(instanceProfileArn);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Instance withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setLastServiceErrorId(String lastServiceErrorId) {
        this.lastServiceErrorId = lastServiceErrorId;
    }

    public String getLastServiceErrorId() {
        return this.lastServiceErrorId;
    }

    public Instance withLastServiceErrorId(String lastServiceErrorId) {
        this.setLastServiceErrorId(lastServiceErrorId);
        return this;
    }

    public List<String> getLayerIds() {
        if (this.layerIds == null) {
            this.layerIds = new SdkInternalList();
        }
        return this.layerIds;
    }

    public void setLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
            return;
        }
        this.layerIds = new SdkInternalList<String>(layerIds);
    }

    public Instance withLayerIds(String ... layerIds) {
        if (this.layerIds == null) {
            this.setLayerIds(new SdkInternalList<String>(layerIds.length));
        }
        for (String ele : layerIds) {
            this.layerIds.add(ele);
        }
        return this;
    }

    public Instance withLayerIds(Collection<String> layerIds) {
        this.setLayerIds(layerIds);
        return this;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    public Instance withOs(String os) {
        this.setOs(os);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Instance withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPrivateDns(String privateDns) {
        this.privateDns = privateDns;
    }

    public String getPrivateDns() {
        return this.privateDns;
    }

    public Instance withPrivateDns(String privateDns) {
        this.setPrivateDns(privateDns);
        return this;
    }

    public void setPrivateIp(String privateIp) {
        this.privateIp = privateIp;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public Instance withPrivateIp(String privateIp) {
        this.setPrivateIp(privateIp);
        return this;
    }

    public void setPublicDns(String publicDns) {
        this.publicDns = publicDns;
    }

    public String getPublicDns() {
        return this.publicDns;
    }

    public Instance withPublicDns(String publicDns) {
        this.setPublicDns(publicDns);
        return this;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public Instance withPublicIp(String publicIp) {
        this.setPublicIp(publicIp);
        return this;
    }

    public void setRegisteredBy(String registeredBy) {
        this.registeredBy = registeredBy;
    }

    public String getRegisteredBy() {
        return this.registeredBy;
    }

    public Instance withRegisteredBy(String registeredBy) {
        this.setRegisteredBy(registeredBy);
        return this;
    }

    public void setReportedAgentVersion(String reportedAgentVersion) {
        this.reportedAgentVersion = reportedAgentVersion;
    }

    public String getReportedAgentVersion() {
        return this.reportedAgentVersion;
    }

    public Instance withReportedAgentVersion(String reportedAgentVersion) {
        this.setReportedAgentVersion(reportedAgentVersion);
        return this;
    }

    public void setReportedOs(ReportedOs reportedOs) {
        this.reportedOs = reportedOs;
    }

    public ReportedOs getReportedOs() {
        return this.reportedOs;
    }

    public Instance withReportedOs(ReportedOs reportedOs) {
        this.setReportedOs(reportedOs);
        return this;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public Instance withRootDeviceType(String rootDeviceType) {
        this.setRootDeviceType(rootDeviceType);
        return this;
    }

    public void setRootDeviceType(RootDeviceType rootDeviceType) {
        this.rootDeviceType = rootDeviceType.toString();
    }

    public Instance withRootDeviceType(RootDeviceType rootDeviceType) {
        this.setRootDeviceType(rootDeviceType);
        return this;
    }

    public void setRootDeviceVolumeId(String rootDeviceVolumeId) {
        this.rootDeviceVolumeId = rootDeviceVolumeId;
    }

    public String getRootDeviceVolumeId() {
        return this.rootDeviceVolumeId;
    }

    public Instance withRootDeviceVolumeId(String rootDeviceVolumeId) {
        this.setRootDeviceVolumeId(rootDeviceVolumeId);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new SdkInternalList();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new SdkInternalList<String>(securityGroupIds);
    }

    public Instance withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new SdkInternalList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public Instance withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public void setSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
        this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
    }

    public String getSshHostDsaKeyFingerprint() {
        return this.sshHostDsaKeyFingerprint;
    }

    public Instance withSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
        this.setSshHostDsaKeyFingerprint(sshHostDsaKeyFingerprint);
        return this;
    }

    public void setSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
        this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
    }

    public String getSshHostRsaKeyFingerprint() {
        return this.sshHostRsaKeyFingerprint;
    }

    public Instance withSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
        this.setSshHostRsaKeyFingerprint(sshHostRsaKeyFingerprint);
        return this;
    }

    public void setSshKeyName(String sshKeyName) {
        this.sshKeyName = sshKeyName;
    }

    public String getSshKeyName() {
        return this.sshKeyName;
    }

    public Instance withSshKeyName(String sshKeyName) {
        this.setSshKeyName(sshKeyName);
        return this;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public Instance withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Instance withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Instance withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public Instance withVirtualizationType(String virtualizationType) {
        this.setVirtualizationType(virtualizationType);
        return this;
    }

    public void setVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
    }

    public Instance withVirtualizationType(VirtualizationType virtualizationType) {
        this.setVirtualizationType(virtualizationType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: " + this.getAgentVersion() + ",");
        }
        if (this.getAmiId() != null) {
            sb.append("AmiId: " + this.getAmiId() + ",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: " + this.getArchitecture() + ",");
        }
        if (this.getAutoScalingType() != null) {
            sb.append("AutoScalingType: " + this.getAutoScalingType() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: " + this.getBlockDeviceMappings() + ",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: " + this.getCreatedAt() + ",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: " + this.getEbsOptimized() + ",");
        }
        if (this.getEc2InstanceId() != null) {
            sb.append("Ec2InstanceId: " + this.getEc2InstanceId() + ",");
        }
        if (this.getEcsClusterArn() != null) {
            sb.append("EcsClusterArn: " + this.getEcsClusterArn() + ",");
        }
        if (this.getEcsContainerInstanceArn() != null) {
            sb.append("EcsContainerInstanceArn: " + this.getEcsContainerInstanceArn() + ",");
        }
        if (this.getElasticIp() != null) {
            sb.append("ElasticIp: " + this.getElasticIp() + ",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: " + this.getHostname() + ",");
        }
        if (this.getInfrastructureClass() != null) {
            sb.append("InfrastructureClass: " + this.getInfrastructureClass() + ",");
        }
        if (this.getInstallUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: " + this.getInstallUpdatesOnBoot() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getInstanceProfileArn() != null) {
            sb.append("InstanceProfileArn: " + this.getInstanceProfileArn() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getLastServiceErrorId() != null) {
            sb.append("LastServiceErrorId: " + this.getLastServiceErrorId() + ",");
        }
        if (this.getLayerIds() != null) {
            sb.append("LayerIds: " + this.getLayerIds() + ",");
        }
        if (this.getOs() != null) {
            sb.append("Os: " + this.getOs() + ",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: " + this.getPlatform() + ",");
        }
        if (this.getPrivateDns() != null) {
            sb.append("PrivateDns: " + this.getPrivateDns() + ",");
        }
        if (this.getPrivateIp() != null) {
            sb.append("PrivateIp: " + this.getPrivateIp() + ",");
        }
        if (this.getPublicDns() != null) {
            sb.append("PublicDns: " + this.getPublicDns() + ",");
        }
        if (this.getPublicIp() != null) {
            sb.append("PublicIp: " + this.getPublicIp() + ",");
        }
        if (this.getRegisteredBy() != null) {
            sb.append("RegisteredBy: " + this.getRegisteredBy() + ",");
        }
        if (this.getReportedAgentVersion() != null) {
            sb.append("ReportedAgentVersion: " + this.getReportedAgentVersion() + ",");
        }
        if (this.getReportedOs() != null) {
            sb.append("ReportedOs: " + this.getReportedOs() + ",");
        }
        if (this.getRootDeviceType() != null) {
            sb.append("RootDeviceType: " + this.getRootDeviceType() + ",");
        }
        if (this.getRootDeviceVolumeId() != null) {
            sb.append("RootDeviceVolumeId: " + this.getRootDeviceVolumeId() + ",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: " + this.getSecurityGroupIds() + ",");
        }
        if (this.getSshHostDsaKeyFingerprint() != null) {
            sb.append("SshHostDsaKeyFingerprint: " + this.getSshHostDsaKeyFingerprint() + ",");
        }
        if (this.getSshHostRsaKeyFingerprint() != null) {
            sb.append("SshHostRsaKeyFingerprint: " + this.getSshHostRsaKeyFingerprint() + ",");
        }
        if (this.getSshKeyName() != null) {
            sb.append("SshKeyName: " + this.getSshKeyName() + ",");
        }
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getVirtualizationType() != null) {
            sb.append("VirtualizationType: " + this.getVirtualizationType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        if (other.getAgentVersion() != null && !other.getAgentVersion().equals(this.getAgentVersion())) {
            return false;
        }
        if (other.getAmiId() == null ^ this.getAmiId() == null) {
            return false;
        }
        if (other.getAmiId() != null && !other.getAmiId().equals(this.getAmiId())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getAutoScalingType() == null ^ this.getAutoScalingType() == null) {
            return false;
        }
        if (other.getAutoScalingType() != null && !other.getAutoScalingType().equals(this.getAutoScalingType())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getEc2InstanceId() == null ^ this.getEc2InstanceId() == null) {
            return false;
        }
        if (other.getEc2InstanceId() != null && !other.getEc2InstanceId().equals(this.getEc2InstanceId())) {
            return false;
        }
        if (other.getEcsClusterArn() == null ^ this.getEcsClusterArn() == null) {
            return false;
        }
        if (other.getEcsClusterArn() != null && !other.getEcsClusterArn().equals(this.getEcsClusterArn())) {
            return false;
        }
        if (other.getEcsContainerInstanceArn() == null ^ this.getEcsContainerInstanceArn() == null) {
            return false;
        }
        if (other.getEcsContainerInstanceArn() != null && !other.getEcsContainerInstanceArn().equals(this.getEcsContainerInstanceArn())) {
            return false;
        }
        if (other.getElasticIp() == null ^ this.getElasticIp() == null) {
            return false;
        }
        if (other.getElasticIp() != null && !other.getElasticIp().equals(this.getElasticIp())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getInfrastructureClass() == null ^ this.getInfrastructureClass() == null) {
            return false;
        }
        if (other.getInfrastructureClass() != null && !other.getInfrastructureClass().equals(this.getInfrastructureClass())) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() == null ^ this.getInstallUpdatesOnBoot() == null) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() != null && !other.getInstallUpdatesOnBoot().equals(this.getInstallUpdatesOnBoot())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getInstanceProfileArn() == null ^ this.getInstanceProfileArn() == null) {
            return false;
        }
        if (other.getInstanceProfileArn() != null && !other.getInstanceProfileArn().equals(this.getInstanceProfileArn())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getLastServiceErrorId() == null ^ this.getLastServiceErrorId() == null) {
            return false;
        }
        if (other.getLastServiceErrorId() != null && !other.getLastServiceErrorId().equals(this.getLastServiceErrorId())) {
            return false;
        }
        if (other.getLayerIds() == null ^ this.getLayerIds() == null) {
            return false;
        }
        if (other.getLayerIds() != null && !other.getLayerIds().equals(this.getLayerIds())) {
            return false;
        }
        if (other.getOs() == null ^ this.getOs() == null) {
            return false;
        }
        if (other.getOs() != null && !other.getOs().equals(this.getOs())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getPrivateDns() == null ^ this.getPrivateDns() == null) {
            return false;
        }
        if (other.getPrivateDns() != null && !other.getPrivateDns().equals(this.getPrivateDns())) {
            return false;
        }
        if (other.getPrivateIp() == null ^ this.getPrivateIp() == null) {
            return false;
        }
        if (other.getPrivateIp() != null && !other.getPrivateIp().equals(this.getPrivateIp())) {
            return false;
        }
        if (other.getPublicDns() == null ^ this.getPublicDns() == null) {
            return false;
        }
        if (other.getPublicDns() != null && !other.getPublicDns().equals(this.getPublicDns())) {
            return false;
        }
        if (other.getPublicIp() == null ^ this.getPublicIp() == null) {
            return false;
        }
        if (other.getPublicIp() != null && !other.getPublicIp().equals(this.getPublicIp())) {
            return false;
        }
        if (other.getRegisteredBy() == null ^ this.getRegisteredBy() == null) {
            return false;
        }
        if (other.getRegisteredBy() != null && !other.getRegisteredBy().equals(this.getRegisteredBy())) {
            return false;
        }
        if (other.getReportedAgentVersion() == null ^ this.getReportedAgentVersion() == null) {
            return false;
        }
        if (other.getReportedAgentVersion() != null && !other.getReportedAgentVersion().equals(this.getReportedAgentVersion())) {
            return false;
        }
        if (other.getReportedOs() == null ^ this.getReportedOs() == null) {
            return false;
        }
        if (other.getReportedOs() != null && !other.getReportedOs().equals(this.getReportedOs())) {
            return false;
        }
        if (other.getRootDeviceType() == null ^ this.getRootDeviceType() == null) {
            return false;
        }
        if (other.getRootDeviceType() != null && !other.getRootDeviceType().equals(this.getRootDeviceType())) {
            return false;
        }
        if (other.getRootDeviceVolumeId() == null ^ this.getRootDeviceVolumeId() == null) {
            return false;
        }
        if (other.getRootDeviceVolumeId() != null && !other.getRootDeviceVolumeId().equals(this.getRootDeviceVolumeId())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSshHostDsaKeyFingerprint() == null ^ this.getSshHostDsaKeyFingerprint() == null) {
            return false;
        }
        if (other.getSshHostDsaKeyFingerprint() != null && !other.getSshHostDsaKeyFingerprint().equals(this.getSshHostDsaKeyFingerprint())) {
            return false;
        }
        if (other.getSshHostRsaKeyFingerprint() == null ^ this.getSshHostRsaKeyFingerprint() == null) {
            return false;
        }
        if (other.getSshHostRsaKeyFingerprint() != null && !other.getSshHostRsaKeyFingerprint().equals(this.getSshHostRsaKeyFingerprint())) {
            return false;
        }
        if (other.getSshKeyName() == null ^ this.getSshKeyName() == null) {
            return false;
        }
        if (other.getSshKeyName() != null && !other.getSshKeyName().equals(this.getSshKeyName())) {
            return false;
        }
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        return other.getVirtualizationType() == null || other.getVirtualizationType().equals(this.getVirtualizationType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAmiId() == null ? 0 : this.getAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingType() == null ? 0 : this.getAutoScalingType().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceId() == null ? 0 : this.getEc2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getEcsClusterArn() == null ? 0 : this.getEcsClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getEcsContainerInstanceArn() == null ? 0 : this.getEcsContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getElasticIp() == null ? 0 : this.getElasticIp().hashCode());
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getInfrastructureClass() == null ? 0 : this.getInfrastructureClass().hashCode());
        hashCode = 31 * hashCode + (this.getInstallUpdatesOnBoot() == null ? 0 : this.getInstallUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileArn() == null ? 0 : this.getInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getLastServiceErrorId() == null ? 0 : this.getLastServiceErrorId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerIds() == null ? 0 : this.getLayerIds().hashCode());
        hashCode = 31 * hashCode + (this.getOs() == null ? 0 : this.getOs().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDns() == null ? 0 : this.getPrivateDns().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIp() == null ? 0 : this.getPrivateIp().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDns() == null ? 0 : this.getPublicDns().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIp() == null ? 0 : this.getPublicIp().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredBy() == null ? 0 : this.getRegisteredBy().hashCode());
        hashCode = 31 * hashCode + (this.getReportedAgentVersion() == null ? 0 : this.getReportedAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getReportedOs() == null ? 0 : this.getReportedOs().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceType() == null ? 0 : this.getRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceVolumeId() == null ? 0 : this.getRootDeviceVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSshHostDsaKeyFingerprint() == null ? 0 : this.getSshHostDsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.getSshHostRsaKeyFingerprint() == null ? 0 : this.getSshHostRsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.getSshKeyName() == null ? 0 : this.getSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        return hashCode;
    }

    public Instance clone() {
        try {
            return (Instance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

