/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest;
import com.amazonaws.services.ec2.model.ReservedInstancesConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyReservedInstancesRequestMarshaller
implements Marshaller<Request<ModifyReservedInstancesRequest>, ModifyReservedInstancesRequest> {
    @Override
    public Request<ModifyReservedInstancesRequest> marshall(ModifyReservedInstancesRequest modifyReservedInstancesRequest) {
        SdkInternalList targetConfigurationsList;
        SdkInternalList reservedInstancesIdsList;
        if (modifyReservedInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyReservedInstancesRequest> request = new DefaultRequest<ModifyReservedInstancesRequest>(modifyReservedInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyReservedInstances");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReservedInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(modifyReservedInstancesRequest.getClientToken()));
        }
        if (!(reservedInstancesIdsList = (SdkInternalList)modifyReservedInstancesRequest.getReservedInstancesIds()).isEmpty() || !reservedInstancesIdsList.isAutoConstruct()) {
            int reservedInstancesIdsListIndex = 1;
            for (String reservedInstancesIdsListValue : reservedInstancesIdsList) {
                if (reservedInstancesIdsListValue != null) {
                    request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex, StringUtils.fromString(reservedInstancesIdsListValue));
                }
                ++reservedInstancesIdsListIndex;
            }
        }
        if (!(targetConfigurationsList = (SdkInternalList)modifyReservedInstancesRequest.getTargetConfigurations()).isEmpty() || !targetConfigurationsList.isAutoConstruct()) {
            int targetConfigurationsListIndex = 1;
            for (ReservedInstancesConfiguration targetConfigurationsListValue : targetConfigurationsList) {
                if (targetConfigurationsListValue.getAvailabilityZone() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".AvailabilityZone", StringUtils.fromString(targetConfigurationsListValue.getAvailabilityZone()));
                }
                if (targetConfigurationsListValue.getPlatform() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Platform", StringUtils.fromString(targetConfigurationsListValue.getPlatform()));
                }
                if (targetConfigurationsListValue.getInstanceCount() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceCount", StringUtils.fromInteger(targetConfigurationsListValue.getInstanceCount()));
                }
                if (targetConfigurationsListValue.getInstanceType() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceType", StringUtils.fromString(targetConfigurationsListValue.getInstanceType()));
                }
                ++targetConfigurationsListIndex;
            }
        }
        return request;
    }
}

