/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.ByteMatchSet;
import com.amazonaws.services.waf.model.ByteMatchTuple;
import com.amazonaws.services.waf.model.transform.ByteMatchTupleJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ByteMatchSetJsonMarshaller {
    private static ByteMatchSetJsonMarshaller instance;

    public void marshall(ByteMatchSet byteMatchSet, JSONWriter jsonWriter) {
        if (byteMatchSet == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ByteMatchTuple> byteMatchTuplesList;
            jsonWriter.object();
            if (byteMatchSet.getByteMatchSetId() != null) {
                jsonWriter.key("ByteMatchSetId").value(byteMatchSet.getByteMatchSetId());
            }
            if (byteMatchSet.getName() != null) {
                jsonWriter.key("Name").value(byteMatchSet.getName());
            }
            if ((byteMatchTuplesList = byteMatchSet.getByteMatchTuples()) != null) {
                jsonWriter.key("ByteMatchTuples");
                jsonWriter.array();
                for (ByteMatchTuple byteMatchTuplesListValue : byteMatchTuplesList) {
                    if (byteMatchTuplesListValue == null) continue;
                    ByteMatchTupleJsonMarshaller.getInstance().marshall(byteMatchTuplesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ByteMatchSetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ByteMatchSetJsonMarshaller();
        }
        return instance;
    }
}

