/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Run;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class RunJsonMarshaller {
    private static RunJsonMarshaller instance;

    public void marshall(Run run, JSONWriter jsonWriter) {
        if (run == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> rulesPackagesList;
            jsonWriter.object();
            if (run.getRunArn() != null) {
                jsonWriter.key("runArn").value(run.getRunArn());
            }
            if (run.getRunName() != null) {
                jsonWriter.key("runName").value(run.getRunName());
            }
            if (run.getAssessmentArn() != null) {
                jsonWriter.key("assessmentArn").value(run.getAssessmentArn());
            }
            if (run.getRunState() != null) {
                jsonWriter.key("runState").value(run.getRunState());
            }
            if ((rulesPackagesList = run.getRulesPackages()) != null) {
                jsonWriter.key("rulesPackages");
                jsonWriter.array();
                for (String rulesPackagesListValue : rulesPackagesList) {
                    if (rulesPackagesListValue == null) continue;
                    jsonWriter.value(rulesPackagesListValue);
                }
                jsonWriter.endArray();
            }
            if (run.getCreationTime() != null) {
                jsonWriter.key("creationTime").value(run.getCreationTime());
            }
            if (run.getCompletionTime() != null) {
                jsonWriter.key("completionTime").value(run.getCompletionTime());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RunJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RunJsonMarshaller();
        }
        return instance;
    }
}

