/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ResourceJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VersionInfoJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RegisterContainerInstanceRequestMarshaller
implements Marshaller<Request<RegisterContainerInstanceRequest>, RegisterContainerInstanceRequest> {
    @Override
    public Request<RegisterContainerInstanceRequest> marshall(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        if (registerContainerInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterContainerInstanceRequest> request = new DefaultRequest<RegisterContainerInstanceRequest>(registerContainerInstanceRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.RegisterContainerInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList attributesList;
            SdkInternalList totalResourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (registerContainerInstanceRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(registerContainerInstanceRequest.getCluster());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocument() != null) {
                jsonWriter.key("instanceIdentityDocument").value(registerContainerInstanceRequest.getInstanceIdentityDocument());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocumentSignature() != null) {
                jsonWriter.key("instanceIdentityDocumentSignature").value(registerContainerInstanceRequest.getInstanceIdentityDocumentSignature());
            }
            if (!(totalResourcesList = (SdkInternalList)registerContainerInstanceRequest.getTotalResources()).isEmpty() || !totalResourcesList.isAutoConstruct()) {
                jsonWriter.key("totalResources");
                jsonWriter.array();
                for (Resource totalResourcesListValue : totalResourcesList) {
                    if (totalResourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall(totalResourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (registerContainerInstanceRequest.getVersionInfo() != null) {
                jsonWriter.key("versionInfo");
                VersionInfoJsonMarshaller.getInstance().marshall(registerContainerInstanceRequest.getVersionInfo(), jsonWriter);
            }
            if (registerContainerInstanceRequest.getContainerInstanceArn() != null) {
                jsonWriter.key("containerInstanceArn").value(registerContainerInstanceRequest.getContainerInstanceArn());
            }
            if (!(attributesList = (SdkInternalList)registerContainerInstanceRequest.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonWriter.key("attributes");
                jsonWriter.array();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

