/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.gamelift.AmazonGameLiftAsync;
import com.amazonaws.services.gamelift.AmazonGameLiftClient;
import com.amazonaws.services.gamelift.model.CreateAliasRequest;
import com.amazonaws.services.gamelift.model.CreateAliasResult;
import com.amazonaws.services.gamelift.model.CreateBuildRequest;
import com.amazonaws.services.gamelift.model.CreateBuildResult;
import com.amazonaws.services.gamelift.model.CreateFleetRequest;
import com.amazonaws.services.gamelift.model.CreateFleetResult;
import com.amazonaws.services.gamelift.model.CreateGameSessionRequest;
import com.amazonaws.services.gamelift.model.CreateGameSessionResult;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionRequest;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionResult;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionsRequest;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionsResult;
import com.amazonaws.services.gamelift.model.DeleteAliasRequest;
import com.amazonaws.services.gamelift.model.DeleteBuildRequest;
import com.amazonaws.services.gamelift.model.DeleteFleetRequest;
import com.amazonaws.services.gamelift.model.DescribeAliasRequest;
import com.amazonaws.services.gamelift.model.DescribeAliasResult;
import com.amazonaws.services.gamelift.model.DescribeBuildRequest;
import com.amazonaws.services.gamelift.model.DescribeBuildResult;
import com.amazonaws.services.gamelift.model.DescribeEC2InstanceLimitsRequest;
import com.amazonaws.services.gamelift.model.DescribeEC2InstanceLimitsResult;
import com.amazonaws.services.gamelift.model.DescribeFleetAttributesRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetAttributesResult;
import com.amazonaws.services.gamelift.model.DescribeFleetCapacityRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetCapacityResult;
import com.amazonaws.services.gamelift.model.DescribeFleetEventsRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetEventsResult;
import com.amazonaws.services.gamelift.model.DescribeFleetPortSettingsRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetPortSettingsResult;
import com.amazonaws.services.gamelift.model.DescribeFleetUtilizationRequest;
import com.amazonaws.services.gamelift.model.DescribeFleetUtilizationResult;
import com.amazonaws.services.gamelift.model.DescribeGameSessionsRequest;
import com.amazonaws.services.gamelift.model.DescribeGameSessionsResult;
import com.amazonaws.services.gamelift.model.DescribePlayerSessionsRequest;
import com.amazonaws.services.gamelift.model.DescribePlayerSessionsResult;
import com.amazonaws.services.gamelift.model.GetGameSessionLogUrlRequest;
import com.amazonaws.services.gamelift.model.GetGameSessionLogUrlResult;
import com.amazonaws.services.gamelift.model.ListAliasesRequest;
import com.amazonaws.services.gamelift.model.ListAliasesResult;
import com.amazonaws.services.gamelift.model.ListBuildsRequest;
import com.amazonaws.services.gamelift.model.ListBuildsResult;
import com.amazonaws.services.gamelift.model.ListFleetsRequest;
import com.amazonaws.services.gamelift.model.ListFleetsResult;
import com.amazonaws.services.gamelift.model.RequestUploadCredentialsRequest;
import com.amazonaws.services.gamelift.model.RequestUploadCredentialsResult;
import com.amazonaws.services.gamelift.model.ResolveAliasRequest;
import com.amazonaws.services.gamelift.model.ResolveAliasResult;
import com.amazonaws.services.gamelift.model.UpdateAliasRequest;
import com.amazonaws.services.gamelift.model.UpdateAliasResult;
import com.amazonaws.services.gamelift.model.UpdateBuildRequest;
import com.amazonaws.services.gamelift.model.UpdateBuildResult;
import com.amazonaws.services.gamelift.model.UpdateFleetAttributesRequest;
import com.amazonaws.services.gamelift.model.UpdateFleetAttributesResult;
import com.amazonaws.services.gamelift.model.UpdateFleetCapacityRequest;
import com.amazonaws.services.gamelift.model.UpdateFleetCapacityResult;
import com.amazonaws.services.gamelift.model.UpdateFleetPortSettingsRequest;
import com.amazonaws.services.gamelift.model.UpdateFleetPortSettingsResult;
import com.amazonaws.services.gamelift.model.UpdateGameSessionRequest;
import com.amazonaws.services.gamelift.model.UpdateGameSessionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonGameLiftAsyncClient
extends AmazonGameLiftClient
implements AmazonGameLiftAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonGameLiftAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonGameLiftAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonGameLiftAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonGameLiftAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonGameLiftAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonGameLiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonGameLiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonGameLiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonGameLiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request) {
        return this.createAliasAsync(request, null);
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(final CreateAliasRequest request, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.createAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBuildResult> createBuildAsync(CreateBuildRequest request) {
        return this.createBuildAsync(request, null);
    }

    @Override
    public Future<CreateBuildResult> createBuildAsync(final CreateBuildRequest request, final AsyncHandler<CreateBuildRequest, CreateBuildResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateBuildResult>(){

            @Override
            public CreateBuildResult call() throws Exception {
                CreateBuildResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.createBuild(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request) {
        return this.createFleetAsync(request, null);
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(final CreateFleetRequest request, final AsyncHandler<CreateFleetRequest, CreateFleetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateFleetResult>(){

            @Override
            public CreateFleetResult call() throws Exception {
                CreateFleetResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.createFleet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGameSessionResult> createGameSessionAsync(CreateGameSessionRequest request) {
        return this.createGameSessionAsync(request, null);
    }

    @Override
    public Future<CreateGameSessionResult> createGameSessionAsync(final CreateGameSessionRequest request, final AsyncHandler<CreateGameSessionRequest, CreateGameSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateGameSessionResult>(){

            @Override
            public CreateGameSessionResult call() throws Exception {
                CreateGameSessionResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.createGameSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePlayerSessionResult> createPlayerSessionAsync(CreatePlayerSessionRequest request) {
        return this.createPlayerSessionAsync(request, null);
    }

    @Override
    public Future<CreatePlayerSessionResult> createPlayerSessionAsync(final CreatePlayerSessionRequest request, final AsyncHandler<CreatePlayerSessionRequest, CreatePlayerSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePlayerSessionResult>(){

            @Override
            public CreatePlayerSessionResult call() throws Exception {
                CreatePlayerSessionResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.createPlayerSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePlayerSessionsResult> createPlayerSessionsAsync(CreatePlayerSessionsRequest request) {
        return this.createPlayerSessionsAsync(request, null);
    }

    @Override
    public Future<CreatePlayerSessionsResult> createPlayerSessionsAsync(final CreatePlayerSessionsRequest request, final AsyncHandler<CreatePlayerSessionsRequest, CreatePlayerSessionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePlayerSessionsResult>(){

            @Override
            public CreatePlayerSessionsResult call() throws Exception {
                CreatePlayerSessionsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.createPlayerSessions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteAliasAsync(DeleteAliasRequest request) {
        return this.deleteAliasAsync(request, null);
    }

    @Override
    public Future<Void> deleteAliasAsync(final DeleteAliasRequest request, final AsyncHandler<DeleteAliasRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonGameLiftAsyncClient.this.deleteAlias(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteBuildAsync(DeleteBuildRequest request) {
        return this.deleteBuildAsync(request, null);
    }

    @Override
    public Future<Void> deleteBuildAsync(final DeleteBuildRequest request, final AsyncHandler<DeleteBuildRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonGameLiftAsyncClient.this.deleteBuild(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteFleetAsync(DeleteFleetRequest request) {
        return this.deleteFleetAsync(request, null);
    }

    @Override
    public Future<Void> deleteFleetAsync(final DeleteFleetRequest request, final AsyncHandler<DeleteFleetRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonGameLiftAsyncClient.this.deleteFleet(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAliasResult> describeAliasAsync(DescribeAliasRequest request) {
        return this.describeAliasAsync(request, null);
    }

    @Override
    public Future<DescribeAliasResult> describeAliasAsync(final DescribeAliasRequest request, final AsyncHandler<DescribeAliasRequest, DescribeAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAliasResult>(){

            @Override
            public DescribeAliasResult call() throws Exception {
                DescribeAliasResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBuildResult> describeBuildAsync(DescribeBuildRequest request) {
        return this.describeBuildAsync(request, null);
    }

    @Override
    public Future<DescribeBuildResult> describeBuildAsync(final DescribeBuildRequest request, final AsyncHandler<DescribeBuildRequest, DescribeBuildResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeBuildResult>(){

            @Override
            public DescribeBuildResult call() throws Exception {
                DescribeBuildResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeBuild(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEC2InstanceLimitsResult> describeEC2InstanceLimitsAsync(DescribeEC2InstanceLimitsRequest request) {
        return this.describeEC2InstanceLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeEC2InstanceLimitsResult> describeEC2InstanceLimitsAsync(final DescribeEC2InstanceLimitsRequest request, final AsyncHandler<DescribeEC2InstanceLimitsRequest, DescribeEC2InstanceLimitsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEC2InstanceLimitsResult>(){

            @Override
            public DescribeEC2InstanceLimitsResult call() throws Exception {
                DescribeEC2InstanceLimitsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeEC2InstanceLimits(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetAttributesResult> describeFleetAttributesAsync(DescribeFleetAttributesRequest request) {
        return this.describeFleetAttributesAsync(request, null);
    }

    @Override
    public Future<DescribeFleetAttributesResult> describeFleetAttributesAsync(final DescribeFleetAttributesRequest request, final AsyncHandler<DescribeFleetAttributesRequest, DescribeFleetAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFleetAttributesResult>(){

            @Override
            public DescribeFleetAttributesResult call() throws Exception {
                DescribeFleetAttributesResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeFleetAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetCapacityResult> describeFleetCapacityAsync(DescribeFleetCapacityRequest request) {
        return this.describeFleetCapacityAsync(request, null);
    }

    @Override
    public Future<DescribeFleetCapacityResult> describeFleetCapacityAsync(final DescribeFleetCapacityRequest request, final AsyncHandler<DescribeFleetCapacityRequest, DescribeFleetCapacityResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFleetCapacityResult>(){

            @Override
            public DescribeFleetCapacityResult call() throws Exception {
                DescribeFleetCapacityResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeFleetCapacity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetEventsResult> describeFleetEventsAsync(DescribeFleetEventsRequest request) {
        return this.describeFleetEventsAsync(request, null);
    }

    @Override
    public Future<DescribeFleetEventsResult> describeFleetEventsAsync(final DescribeFleetEventsRequest request, final AsyncHandler<DescribeFleetEventsRequest, DescribeFleetEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFleetEventsResult>(){

            @Override
            public DescribeFleetEventsResult call() throws Exception {
                DescribeFleetEventsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeFleetEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetPortSettingsResult> describeFleetPortSettingsAsync(DescribeFleetPortSettingsRequest request) {
        return this.describeFleetPortSettingsAsync(request, null);
    }

    @Override
    public Future<DescribeFleetPortSettingsResult> describeFleetPortSettingsAsync(final DescribeFleetPortSettingsRequest request, final AsyncHandler<DescribeFleetPortSettingsRequest, DescribeFleetPortSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFleetPortSettingsResult>(){

            @Override
            public DescribeFleetPortSettingsResult call() throws Exception {
                DescribeFleetPortSettingsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeFleetPortSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetUtilizationResult> describeFleetUtilizationAsync(DescribeFleetUtilizationRequest request) {
        return this.describeFleetUtilizationAsync(request, null);
    }

    @Override
    public Future<DescribeFleetUtilizationResult> describeFleetUtilizationAsync(final DescribeFleetUtilizationRequest request, final AsyncHandler<DescribeFleetUtilizationRequest, DescribeFleetUtilizationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFleetUtilizationResult>(){

            @Override
            public DescribeFleetUtilizationResult call() throws Exception {
                DescribeFleetUtilizationResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeFleetUtilization(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGameSessionsResult> describeGameSessionsAsync(DescribeGameSessionsRequest request) {
        return this.describeGameSessionsAsync(request, null);
    }

    @Override
    public Future<DescribeGameSessionsResult> describeGameSessionsAsync(final DescribeGameSessionsRequest request, final AsyncHandler<DescribeGameSessionsRequest, DescribeGameSessionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeGameSessionsResult>(){

            @Override
            public DescribeGameSessionsResult call() throws Exception {
                DescribeGameSessionsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describeGameSessions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePlayerSessionsResult> describePlayerSessionsAsync(DescribePlayerSessionsRequest request) {
        return this.describePlayerSessionsAsync(request, null);
    }

    @Override
    public Future<DescribePlayerSessionsResult> describePlayerSessionsAsync(final DescribePlayerSessionsRequest request, final AsyncHandler<DescribePlayerSessionsRequest, DescribePlayerSessionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribePlayerSessionsResult>(){

            @Override
            public DescribePlayerSessionsResult call() throws Exception {
                DescribePlayerSessionsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.describePlayerSessions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGameSessionLogUrlResult> getGameSessionLogUrlAsync(GetGameSessionLogUrlRequest request) {
        return this.getGameSessionLogUrlAsync(request, null);
    }

    @Override
    public Future<GetGameSessionLogUrlResult> getGameSessionLogUrlAsync(final GetGameSessionLogUrlRequest request, final AsyncHandler<GetGameSessionLogUrlRequest, GetGameSessionLogUrlResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetGameSessionLogUrlResult>(){

            @Override
            public GetGameSessionLogUrlResult call() throws Exception {
                GetGameSessionLogUrlResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.getGameSessionLogUrl(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(ListAliasesRequest request) {
        return this.listAliasesAsync(request, null);
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(final ListAliasesRequest request, final AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAliasesResult>(){

            @Override
            public ListAliasesResult call() throws Exception {
                ListAliasesResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.listAliases(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBuildsResult> listBuildsAsync(ListBuildsRequest request) {
        return this.listBuildsAsync(request, null);
    }

    @Override
    public Future<ListBuildsResult> listBuildsAsync(final ListBuildsRequest request, final AsyncHandler<ListBuildsRequest, ListBuildsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListBuildsResult>(){

            @Override
            public ListBuildsResult call() throws Exception {
                ListBuildsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.listBuilds(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request) {
        return this.listFleetsAsync(request, null);
    }

    @Override
    public Future<ListFleetsResult> listFleetsAsync(final ListFleetsRequest request, final AsyncHandler<ListFleetsRequest, ListFleetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListFleetsResult>(){

            @Override
            public ListFleetsResult call() throws Exception {
                ListFleetsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.listFleets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RequestUploadCredentialsResult> requestUploadCredentialsAsync(RequestUploadCredentialsRequest request) {
        return this.requestUploadCredentialsAsync(request, null);
    }

    @Override
    public Future<RequestUploadCredentialsResult> requestUploadCredentialsAsync(final RequestUploadCredentialsRequest request, final AsyncHandler<RequestUploadCredentialsRequest, RequestUploadCredentialsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RequestUploadCredentialsResult>(){

            @Override
            public RequestUploadCredentialsResult call() throws Exception {
                RequestUploadCredentialsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.requestUploadCredentials(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResolveAliasResult> resolveAliasAsync(ResolveAliasRequest request) {
        return this.resolveAliasAsync(request, null);
    }

    @Override
    public Future<ResolveAliasResult> resolveAliasAsync(final ResolveAliasRequest request, final AsyncHandler<ResolveAliasRequest, ResolveAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResolveAliasResult>(){

            @Override
            public ResolveAliasResult call() throws Exception {
                ResolveAliasResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.resolveAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(UpdateAliasRequest request) {
        return this.updateAliasAsync(request, null);
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(final UpdateAliasRequest request, final AsyncHandler<UpdateAliasRequest, UpdateAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateAliasResult>(){

            @Override
            public UpdateAliasResult call() throws Exception {
                UpdateAliasResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.updateAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBuildResult> updateBuildAsync(UpdateBuildRequest request) {
        return this.updateBuildAsync(request, null);
    }

    @Override
    public Future<UpdateBuildResult> updateBuildAsync(final UpdateBuildRequest request, final AsyncHandler<UpdateBuildRequest, UpdateBuildResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateBuildResult>(){

            @Override
            public UpdateBuildResult call() throws Exception {
                UpdateBuildResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.updateBuild(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFleetAttributesResult> updateFleetAttributesAsync(UpdateFleetAttributesRequest request) {
        return this.updateFleetAttributesAsync(request, null);
    }

    @Override
    public Future<UpdateFleetAttributesResult> updateFleetAttributesAsync(final UpdateFleetAttributesRequest request, final AsyncHandler<UpdateFleetAttributesRequest, UpdateFleetAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateFleetAttributesResult>(){

            @Override
            public UpdateFleetAttributesResult call() throws Exception {
                UpdateFleetAttributesResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.updateFleetAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFleetCapacityResult> updateFleetCapacityAsync(UpdateFleetCapacityRequest request) {
        return this.updateFleetCapacityAsync(request, null);
    }

    @Override
    public Future<UpdateFleetCapacityResult> updateFleetCapacityAsync(final UpdateFleetCapacityRequest request, final AsyncHandler<UpdateFleetCapacityRequest, UpdateFleetCapacityResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateFleetCapacityResult>(){

            @Override
            public UpdateFleetCapacityResult call() throws Exception {
                UpdateFleetCapacityResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.updateFleetCapacity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFleetPortSettingsResult> updateFleetPortSettingsAsync(UpdateFleetPortSettingsRequest request) {
        return this.updateFleetPortSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateFleetPortSettingsResult> updateFleetPortSettingsAsync(final UpdateFleetPortSettingsRequest request, final AsyncHandler<UpdateFleetPortSettingsRequest, UpdateFleetPortSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateFleetPortSettingsResult>(){

            @Override
            public UpdateFleetPortSettingsResult call() throws Exception {
                UpdateFleetPortSettingsResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.updateFleetPortSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGameSessionResult> updateGameSessionAsync(UpdateGameSessionRequest request) {
        return this.updateGameSessionAsync(request, null);
    }

    @Override
    public Future<UpdateGameSessionResult> updateGameSessionAsync(final UpdateGameSessionRequest request, final AsyncHandler<UpdateGameSessionRequest, UpdateGameSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateGameSessionResult>(){

            @Override
            public UpdateGameSessionResult call() throws Exception {
                UpdateGameSessionResult result;
                try {
                    result = AmazonGameLiftAsyncClient.this.updateGameSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

