/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeApplicationVersionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private ListWithAutoConstructFlag<String> versionLabels;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public DescribeApplicationVersionsRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public List<String> getVersionLabels() {
        if (this.versionLabels == null) {
            this.versionLabels = new ListWithAutoConstructFlag();
            this.versionLabels.setAutoConstruct(true);
        }
        return this.versionLabels;
    }

    public void setVersionLabels(Collection<String> versionLabels) {
        if (versionLabels == null) {
            this.versionLabels = null;
            return;
        }
        ListWithAutoConstructFlag versionLabelsCopy = new ListWithAutoConstructFlag(versionLabels.size());
        versionLabelsCopy.addAll(versionLabels);
        this.versionLabels = versionLabelsCopy;
    }

    public DescribeApplicationVersionsRequest withVersionLabels(String ... versionLabels) {
        if (this.getVersionLabels() == null) {
            this.setVersionLabels(new ArrayList<String>(versionLabels.length));
        }
        for (String value : versionLabels) {
            this.getVersionLabels().add(value);
        }
        return this;
    }

    public DescribeApplicationVersionsRequest withVersionLabels(Collection<String> versionLabels) {
        if (versionLabels == null) {
            this.versionLabels = null;
        } else {
            ListWithAutoConstructFlag versionLabelsCopy = new ListWithAutoConstructFlag(versionLabels.size());
            versionLabelsCopy.addAll(versionLabels);
            this.versionLabels = versionLabelsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getVersionLabels() != null) {
            sb.append("VersionLabels: " + this.getVersionLabels());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabels() == null ? 0 : this.getVersionLabels().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationVersionsRequest)) {
            return false;
        }
        DescribeApplicationVersionsRequest other = (DescribeApplicationVersionsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getVersionLabels() == null ^ this.getVersionLabels() == null) {
            return false;
        }
        return other.getVersionLabels() == null || other.getVersionLabels().equals(this.getVersionLabels());
    }

    @Override
    public DescribeApplicationVersionsRequest clone() {
        return (DescribeApplicationVersionsRequest)super.clone();
    }
}

