/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.transform.InputLogEventJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PutLogEventsRequestMarshaller
implements Marshaller<Request<PutLogEventsRequest>, PutLogEventsRequest> {
    @Override
    public Request<PutLogEventsRequest> marshall(PutLogEventsRequest putLogEventsRequest) {
        if (putLogEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutLogEventsRequest> request = new DefaultRequest<PutLogEventsRequest>(putLogEventsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.PutLogEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList logEventsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putLogEventsRequest.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value(putLogEventsRequest.getLogGroupName());
            }
            if (putLogEventsRequest.getLogStreamName() != null) {
                jsonWriter.key("logStreamName").value(putLogEventsRequest.getLogStreamName());
            }
            if (!(logEventsList = (SdkInternalList)putLogEventsRequest.getLogEvents()).isEmpty() || !logEventsList.isAutoConstruct()) {
                jsonWriter.key("logEvents");
                jsonWriter.array();
                for (InputLogEvent logEventsListValue : logEventsList) {
                    if (logEventsListValue == null) continue;
                    InputLogEventJsonMarshaller.getInstance().marshall(logEventsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (putLogEventsRequest.getSequenceToken() != null) {
                jsonWriter.key("sequenceToken").value(putLogEventsRequest.getSequenceToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

