/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.CreateAssessmentRequest;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class CreateAssessmentRequestMarshaller
implements Marshaller<Request<CreateAssessmentRequest>, CreateAssessmentRequest> {
    @Override
    public Request<CreateAssessmentRequest> marshall(CreateAssessmentRequest createAssessmentRequest) {
        if (createAssessmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAssessmentRequest> request = new DefaultRequest<CreateAssessmentRequest>(createAssessmentRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateAssessment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> userAttributesForFindingsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createAssessmentRequest.getApplicationArn() != null) {
                jsonWriter.key("applicationArn").value(createAssessmentRequest.getApplicationArn());
            }
            if (createAssessmentRequest.getAssessmentName() != null) {
                jsonWriter.key("assessmentName").value(createAssessmentRequest.getAssessmentName());
            }
            if (createAssessmentRequest.getDurationInSeconds() != null) {
                jsonWriter.key("durationInSeconds").value(createAssessmentRequest.getDurationInSeconds());
            }
            if ((userAttributesForFindingsList = createAssessmentRequest.getUserAttributesForFindings()) != null) {
                jsonWriter.key("userAttributesForFindings");
                jsonWriter.array();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

