/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.IntegrationResponse;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class IntegrationResponseJsonMarshaller {
    private static IntegrationResponseJsonMarshaller instance;

    public void marshall(IntegrationResponse integrationResponse, JSONWriter jsonWriter) {
        if (integrationResponse == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> responseTemplatesMap;
            Map<String, String> responseParametersMap;
            jsonWriter.object();
            if (integrationResponse.getStatusCode() != null) {
                jsonWriter.key("statusCode").value(integrationResponse.getStatusCode());
            }
            if (integrationResponse.getSelectionPattern() != null) {
                jsonWriter.key("selectionPattern").value(integrationResponse.getSelectionPattern());
            }
            if ((responseParametersMap = integrationResponse.getResponseParameters()) != null) {
                jsonWriter.key("responseParameters");
                jsonWriter.object();
                for (Map.Entry<String, String> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(responseParametersMapValue.getKey());
                    jsonWriter.value(responseParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((responseTemplatesMap = integrationResponse.getResponseTemplates()) != null) {
                jsonWriter.key("responseTemplates");
                jsonWriter.object();
                for (Map.Entry<String, String> responseTemplatesMapValue : responseTemplatesMap.entrySet()) {
                    if (responseTemplatesMapValue.getValue() == null) continue;
                    jsonWriter.key(responseTemplatesMapValue.getKey());
                    jsonWriter.value(responseTemplatesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IntegrationResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IntegrationResponseJsonMarshaller();
        }
        return instance;
    }
}

