/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.StepSummary;
import com.amazonaws.services.elasticmapreduce.model.transform.HadoopStepConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepStatusJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class StepSummaryJsonMarshaller {
    private static StepSummaryJsonMarshaller instance;

    public void marshall(StepSummary stepSummary, JSONWriter jsonWriter) {
        if (stepSummary == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (stepSummary.getId() != null) {
                jsonWriter.key("Id").value(stepSummary.getId());
            }
            if (stepSummary.getName() != null) {
                jsonWriter.key("Name").value(stepSummary.getName());
            }
            if (stepSummary.getConfig() != null) {
                jsonWriter.key("Config");
                HadoopStepConfigJsonMarshaller.getInstance().marshall(stepSummary.getConfig(), jsonWriter);
            }
            if (stepSummary.getActionOnFailure() != null) {
                jsonWriter.key("ActionOnFailure").value(stepSummary.getActionOnFailure());
            }
            if (stepSummary.getStatus() != null) {
                jsonWriter.key("Status");
                StepStatusJsonMarshaller.getInstance().marshall(stepSummary.getStatus(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepSummaryJsonMarshaller();
        }
        return instance;
    }
}

