/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.transform.ParameterObjectJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ParameterValueJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PipelineObjectJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PutPipelineDefinitionRequestMarshaller
implements Marshaller<Request<PutPipelineDefinitionRequest>, PutPipelineDefinitionRequest> {
    @Override
    public Request<PutPipelineDefinitionRequest> marshall(PutPipelineDefinitionRequest putPipelineDefinitionRequest) {
        if (putPipelineDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutPipelineDefinitionRequest> request = new DefaultRequest<PutPipelineDefinitionRequest>(putPipelineDefinitionRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.PutPipelineDefinition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList parameterValuesList;
            SdkInternalList parameterObjectsList;
            SdkInternalList pipelineObjectsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putPipelineDefinitionRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(putPipelineDefinitionRequest.getPipelineId());
            }
            if (!(pipelineObjectsList = (SdkInternalList)putPipelineDefinitionRequest.getPipelineObjects()).isEmpty() || !pipelineObjectsList.isAutoConstruct()) {
                jsonWriter.key("pipelineObjects");
                jsonWriter.array();
                for (PipelineObject pipelineObjectsListValue : pipelineObjectsList) {
                    if (pipelineObjectsListValue == null) continue;
                    PipelineObjectJsonMarshaller.getInstance().marshall(pipelineObjectsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(parameterObjectsList = (SdkInternalList)putPipelineDefinitionRequest.getParameterObjects()).isEmpty() || !parameterObjectsList.isAutoConstruct()) {
                jsonWriter.key("parameterObjects");
                jsonWriter.array();
                for (ParameterObject parameterObjectsListValue : parameterObjectsList) {
                    if (parameterObjectsListValue == null) continue;
                    ParameterObjectJsonMarshaller.getInstance().marshall(parameterObjectsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(parameterValuesList = (SdkInternalList)putPipelineDefinitionRequest.getParameterValues()).isEmpty() || !parameterValuesList.isAutoConstruct()) {
                jsonWriter.key("parameterValues");
                jsonWriter.array();
                for (ParameterValue parameterValuesListValue : parameterValuesList) {
                    if (parameterValuesListValue == null) continue;
                    ParameterValueJsonMarshaller.getInstance().marshall(parameterValuesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

