/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.StartDataCollectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class StartDataCollectionRequestMarshaller
implements Marshaller<Request<StartDataCollectionRequest>, StartDataCollectionRequest> {
    @Override
    public Request<StartDataCollectionRequest> marshall(StartDataCollectionRequest startDataCollectionRequest) {
        if (startDataCollectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartDataCollectionRequest> request = new DefaultRequest<StartDataCollectionRequest>(startDataCollectionRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.StartDataCollection");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (startDataCollectionRequest.getAssessmentArn() != null) {
                jsonWriter.key("assessmentArn").value(startDataCollectionRequest.getAssessmentArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

