/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.storagegateway.model.NetworkInterface;
import com.amazonaws.util.json.JSONWriter;

public class NetworkInterfaceJsonMarshaller {
    private static NetworkInterfaceJsonMarshaller instance;

    public void marshall(NetworkInterface networkInterface, JSONWriter jsonWriter) {
        if (networkInterface == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (networkInterface.getIpv4Address() != null) {
                jsonWriter.key("Ipv4Address").value(networkInterface.getIpv4Address());
            }
            if (networkInterface.getMacAddress() != null) {
                jsonWriter.key("MacAddress").value(networkInterface.getMacAddress());
            }
            if (networkInterface.getIpv6Address() != null) {
                jsonWriter.key("Ipv6Address").value(networkInterface.getIpv6Address());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NetworkInterfaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkInterfaceJsonMarshaller();
        }
        return instance;
    }
}

