/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.NetworkBinding;
import com.amazonaws.services.ecs.model.transform.NetworkBindingJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ContainerJsonMarshaller {
    private static ContainerJsonMarshaller instance;

    public void marshall(Container container, JSONWriter jsonWriter) {
        if (container == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList networkBindingsList;
            jsonWriter.object();
            if (container.getContainerArn() != null) {
                jsonWriter.key("containerArn").value(container.getContainerArn());
            }
            if (container.getTaskArn() != null) {
                jsonWriter.key("taskArn").value(container.getTaskArn());
            }
            if (container.getName() != null) {
                jsonWriter.key("name").value(container.getName());
            }
            if (container.getLastStatus() != null) {
                jsonWriter.key("lastStatus").value(container.getLastStatus());
            }
            if (container.getExitCode() != null) {
                jsonWriter.key("exitCode").value(container.getExitCode());
            }
            if (container.getReason() != null) {
                jsonWriter.key("reason").value(container.getReason());
            }
            if (!(networkBindingsList = (SdkInternalList)container.getNetworkBindings()).isEmpty() || !networkBindingsList.isAutoConstruct()) {
                jsonWriter.key("networkBindings");
                jsonWriter.array();
                for (NetworkBinding networkBindingsListValue : networkBindingsList) {
                    if (networkBindingsListValue == null) continue;
                    NetworkBindingJsonMarshaller.getInstance().marshall(networkBindingsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerJsonMarshaller();
        }
        return instance;
    }
}

