/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.PipelineDescription;
import com.amazonaws.services.datapipeline.model.Tag;
import com.amazonaws.services.datapipeline.model.transform.FieldJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.TagJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PipelineDescriptionJsonMarshaller {
    private static PipelineDescriptionJsonMarshaller instance;

    public void marshall(PipelineDescription pipelineDescription, JSONWriter jsonWriter) {
        if (pipelineDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList tagsList;
            SdkInternalList fieldsList;
            jsonWriter.object();
            if (pipelineDescription.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(pipelineDescription.getPipelineId());
            }
            if (pipelineDescription.getName() != null) {
                jsonWriter.key("name").value(pipelineDescription.getName());
            }
            if (!(fieldsList = (SdkInternalList)pipelineDescription.getFields()).isEmpty() || !fieldsList.isAutoConstruct()) {
                jsonWriter.key("fields");
                jsonWriter.array();
                for (Field fieldsListValue : fieldsList) {
                    if (fieldsListValue == null) continue;
                    FieldJsonMarshaller.getInstance().marshall(fieldsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (pipelineDescription.getDescription() != null) {
                jsonWriter.key("description").value(pipelineDescription.getDescription());
            }
            if (!(tagsList = (SdkInternalList)pipelineDescription.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonWriter.key("tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineDescriptionJsonMarshaller();
        }
        return instance;
    }
}

