/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.config.AmazonConfigAsync;
import com.amazonaws.services.config.AmazonConfigClient;
import com.amazonaws.services.config.model.DeleteConfigRuleRequest;
import com.amazonaws.services.config.model.DeleteDeliveryChannelRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotResult;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleRequest;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleResult;
import com.amazonaws.services.config.model.DescribeComplianceByResourceRequest;
import com.amazonaws.services.config.model.DescribeComplianceByResourceResult;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusResult;
import com.amazonaws.services.config.model.DescribeConfigRulesRequest;
import com.amazonaws.services.config.model.DescribeConfigRulesResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeResult;
import com.amazonaws.services.config.model.GetResourceConfigHistoryRequest;
import com.amazonaws.services.config.model.GetResourceConfigHistoryResult;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.services.config.model.ListDiscoveredResourcesResult;
import com.amazonaws.services.config.model.PutConfigRuleRequest;
import com.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.PutEvaluationsResult;
import com.amazonaws.services.config.model.StartConfigurationRecorderRequest;
import com.amazonaws.services.config.model.StopConfigurationRecorderRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonConfigAsyncClient
extends AmazonConfigClient
implements AmazonConfigAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonConfigAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonConfigAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> deleteConfigRuleAsync(DeleteConfigRuleRequest request) {
        return this.deleteConfigRuleAsync(request, null);
    }

    @Override
    public Future<Void> deleteConfigRuleAsync(final DeleteConfigRuleRequest request, final AsyncHandler<DeleteConfigRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonConfigAsyncClient.this.deleteConfigRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteDeliveryChannelAsync(DeleteDeliveryChannelRequest request) {
        return this.deleteDeliveryChannelAsync(request, null);
    }

    @Override
    public Future<Void> deleteDeliveryChannelAsync(final DeleteDeliveryChannelRequest request, final AsyncHandler<DeleteDeliveryChannelRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonConfigAsyncClient.this.deleteDeliveryChannel(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(DeliverConfigSnapshotRequest request) {
        return this.deliverConfigSnapshotAsync(request, null);
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(final DeliverConfigSnapshotRequest request, final AsyncHandler<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeliverConfigSnapshotResult>(){

            @Override
            public DeliverConfigSnapshotResult call() throws Exception {
                DeliverConfigSnapshotResult result;
                try {
                    result = AmazonConfigAsyncClient.this.deliverConfigSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(DescribeComplianceByConfigRuleRequest request) {
        return this.describeComplianceByConfigRuleAsync(request, null);
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(final DescribeComplianceByConfigRuleRequest request, final AsyncHandler<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeComplianceByConfigRuleResult>(){

            @Override
            public DescribeComplianceByConfigRuleResult call() throws Exception {
                DescribeComplianceByConfigRuleResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeComplianceByConfigRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync() {
        return this.describeComplianceByConfigRuleAsync(new DescribeComplianceByConfigRuleRequest());
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(AsyncHandler<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResult> asyncHandler) {
        return this.describeComplianceByConfigRuleAsync(new DescribeComplianceByConfigRuleRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(DescribeComplianceByResourceRequest request) {
        return this.describeComplianceByResourceAsync(request, null);
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(final DescribeComplianceByResourceRequest request, final AsyncHandler<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeComplianceByResourceResult>(){

            @Override
            public DescribeComplianceByResourceResult call() throws Exception {
                DescribeComplianceByResourceResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeComplianceByResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync() {
        return this.describeComplianceByResourceAsync(new DescribeComplianceByResourceRequest());
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(AsyncHandler<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResult> asyncHandler) {
        return this.describeComplianceByResourceAsync(new DescribeComplianceByResourceRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(DescribeConfigRuleEvaluationStatusRequest request) {
        return this.describeConfigRuleEvaluationStatusAsync(request, null);
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(final DescribeConfigRuleEvaluationStatusRequest request, final AsyncHandler<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConfigRuleEvaluationStatusResult>(){

            @Override
            public DescribeConfigRuleEvaluationStatusResult call() throws Exception {
                DescribeConfigRuleEvaluationStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigRuleEvaluationStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync() {
        return this.describeConfigRuleEvaluationStatusAsync(new DescribeConfigRuleEvaluationStatusRequest());
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(AsyncHandler<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResult> asyncHandler) {
        return this.describeConfigRuleEvaluationStatusAsync(new DescribeConfigRuleEvaluationStatusRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(DescribeConfigRulesRequest request) {
        return this.describeConfigRulesAsync(request, null);
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(final DescribeConfigRulesRequest request, final AsyncHandler<DescribeConfigRulesRequest, DescribeConfigRulesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConfigRulesResult>(){

            @Override
            public DescribeConfigRulesResult call() throws Exception {
                DescribeConfigRulesResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigRules(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync() {
        return this.describeConfigRulesAsync(new DescribeConfigRulesRequest());
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(AsyncHandler<DescribeConfigRulesRequest, DescribeConfigRulesResult> asyncHandler) {
        return this.describeConfigRulesAsync(new DescribeConfigRulesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(DescribeConfigurationRecorderStatusRequest request) {
        return this.describeConfigurationRecorderStatusAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(final DescribeConfigurationRecorderStatusRequest request, final AsyncHandler<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConfigurationRecorderStatusResult>(){

            @Override
            public DescribeConfigurationRecorderStatusResult call() throws Exception {
                DescribeConfigurationRecorderStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigurationRecorderStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync() {
        return this.describeConfigurationRecorderStatusAsync(new DescribeConfigurationRecorderStatusRequest());
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(AsyncHandler<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResult> asyncHandler) {
        return this.describeConfigurationRecorderStatusAsync(new DescribeConfigurationRecorderStatusRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(DescribeConfigurationRecordersRequest request) {
        return this.describeConfigurationRecordersAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(final DescribeConfigurationRecordersRequest request, final AsyncHandler<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConfigurationRecordersResult>(){

            @Override
            public DescribeConfigurationRecordersResult call() throws Exception {
                DescribeConfigurationRecordersResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigurationRecorders(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync() {
        return this.describeConfigurationRecordersAsync(new DescribeConfigurationRecordersRequest());
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(AsyncHandler<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResult> asyncHandler) {
        return this.describeConfigurationRecordersAsync(new DescribeConfigurationRecordersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(DescribeDeliveryChannelStatusRequest request) {
        return this.describeDeliveryChannelStatusAsync(request, null);
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(final DescribeDeliveryChannelStatusRequest request, final AsyncHandler<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelStatusResult>(){

            @Override
            public DescribeDeliveryChannelStatusResult call() throws Exception {
                DescribeDeliveryChannelStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeDeliveryChannelStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync() {
        return this.describeDeliveryChannelStatusAsync(new DescribeDeliveryChannelStatusRequest());
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(AsyncHandler<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResult> asyncHandler) {
        return this.describeDeliveryChannelStatusAsync(new DescribeDeliveryChannelStatusRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(DescribeDeliveryChannelsRequest request) {
        return this.describeDeliveryChannelsAsync(request, null);
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(final DescribeDeliveryChannelsRequest request, final AsyncHandler<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelsResult>(){

            @Override
            public DescribeDeliveryChannelsResult call() throws Exception {
                DescribeDeliveryChannelsResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeDeliveryChannels(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync() {
        return this.describeDeliveryChannelsAsync(new DescribeDeliveryChannelsRequest());
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(AsyncHandler<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResult> asyncHandler) {
        return this.describeDeliveryChannelsAsync(new DescribeDeliveryChannelsRequest(), asyncHandler);
    }

    @Override
    public Future<GetComplianceDetailsByConfigRuleResult> getComplianceDetailsByConfigRuleAsync(GetComplianceDetailsByConfigRuleRequest request) {
        return this.getComplianceDetailsByConfigRuleAsync(request, null);
    }

    @Override
    public Future<GetComplianceDetailsByConfigRuleResult> getComplianceDetailsByConfigRuleAsync(final GetComplianceDetailsByConfigRuleRequest request, final AsyncHandler<GetComplianceDetailsByConfigRuleRequest, GetComplianceDetailsByConfigRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetComplianceDetailsByConfigRuleResult>(){

            @Override
            public GetComplianceDetailsByConfigRuleResult call() throws Exception {
                GetComplianceDetailsByConfigRuleResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceDetailsByConfigRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceDetailsByResourceResult> getComplianceDetailsByResourceAsync(GetComplianceDetailsByResourceRequest request) {
        return this.getComplianceDetailsByResourceAsync(request, null);
    }

    @Override
    public Future<GetComplianceDetailsByResourceResult> getComplianceDetailsByResourceAsync(final GetComplianceDetailsByResourceRequest request, final AsyncHandler<GetComplianceDetailsByResourceRequest, GetComplianceDetailsByResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetComplianceDetailsByResourceResult>(){

            @Override
            public GetComplianceDetailsByResourceResult call() throws Exception {
                GetComplianceDetailsByResourceResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceDetailsByResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(GetComplianceSummaryByConfigRuleRequest request) {
        return this.getComplianceSummaryByConfigRuleAsync(request, null);
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(final GetComplianceSummaryByConfigRuleRequest request, final AsyncHandler<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetComplianceSummaryByConfigRuleResult>(){

            @Override
            public GetComplianceSummaryByConfigRuleResult call() throws Exception {
                GetComplianceSummaryByConfigRuleResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceSummaryByConfigRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync() {
        return this.getComplianceSummaryByConfigRuleAsync(new GetComplianceSummaryByConfigRuleRequest());
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(AsyncHandler<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResult> asyncHandler) {
        return this.getComplianceSummaryByConfigRuleAsync(new GetComplianceSummaryByConfigRuleRequest(), asyncHandler);
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(GetComplianceSummaryByResourceTypeRequest request) {
        return this.getComplianceSummaryByResourceTypeAsync(request, null);
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(final GetComplianceSummaryByResourceTypeRequest request, final AsyncHandler<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetComplianceSummaryByResourceTypeResult>(){

            @Override
            public GetComplianceSummaryByResourceTypeResult call() throws Exception {
                GetComplianceSummaryByResourceTypeResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceSummaryByResourceType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync() {
        return this.getComplianceSummaryByResourceTypeAsync(new GetComplianceSummaryByResourceTypeRequest());
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(AsyncHandler<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResult> asyncHandler) {
        return this.getComplianceSummaryByResourceTypeAsync(new GetComplianceSummaryByResourceTypeRequest(), asyncHandler);
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(GetResourceConfigHistoryRequest request) {
        return this.getResourceConfigHistoryAsync(request, null);
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(final GetResourceConfigHistoryRequest request, final AsyncHandler<GetResourceConfigHistoryRequest, GetResourceConfigHistoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetResourceConfigHistoryResult>(){

            @Override
            public GetResourceConfigHistoryResult call() throws Exception {
                GetResourceConfigHistoryResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getResourceConfigHistory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDiscoveredResourcesResult> listDiscoveredResourcesAsync(ListDiscoveredResourcesRequest request) {
        return this.listDiscoveredResourcesAsync(request, null);
    }

    @Override
    public Future<ListDiscoveredResourcesResult> listDiscoveredResourcesAsync(final ListDiscoveredResourcesRequest request, final AsyncHandler<ListDiscoveredResourcesRequest, ListDiscoveredResourcesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDiscoveredResourcesResult>(){

            @Override
            public ListDiscoveredResourcesResult call() throws Exception {
                ListDiscoveredResourcesResult result;
                try {
                    result = AmazonConfigAsyncClient.this.listDiscoveredResources(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putConfigRuleAsync(PutConfigRuleRequest request) {
        return this.putConfigRuleAsync(request, null);
    }

    @Override
    public Future<Void> putConfigRuleAsync(final PutConfigRuleRequest request, final AsyncHandler<PutConfigRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonConfigAsyncClient.this.putConfigRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putConfigurationRecorderAsync(PutConfigurationRecorderRequest request) {
        return this.putConfigurationRecorderAsync(request, null);
    }

    @Override
    public Future<Void> putConfigurationRecorderAsync(final PutConfigurationRecorderRequest request, final AsyncHandler<PutConfigurationRecorderRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonConfigAsyncClient.this.putConfigurationRecorder(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putDeliveryChannelAsync(PutDeliveryChannelRequest request) {
        return this.putDeliveryChannelAsync(request, null);
    }

    @Override
    public Future<Void> putDeliveryChannelAsync(final PutDeliveryChannelRequest request, final AsyncHandler<PutDeliveryChannelRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonConfigAsyncClient.this.putDeliveryChannel(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEvaluationsResult> putEvaluationsAsync(PutEvaluationsRequest request) {
        return this.putEvaluationsAsync(request, null);
    }

    @Override
    public Future<PutEvaluationsResult> putEvaluationsAsync(final PutEvaluationsRequest request, final AsyncHandler<PutEvaluationsRequest, PutEvaluationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutEvaluationsResult>(){

            @Override
            public PutEvaluationsResult call() throws Exception {
                PutEvaluationsResult result;
                try {
                    result = AmazonConfigAsyncClient.this.putEvaluations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> startConfigurationRecorderAsync(StartConfigurationRecorderRequest request) {
        return this.startConfigurationRecorderAsync(request, null);
    }

    @Override
    public Future<Void> startConfigurationRecorderAsync(final StartConfigurationRecorderRequest request, final AsyncHandler<StartConfigurationRecorderRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonConfigAsyncClient.this.startConfigurationRecorder(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> stopConfigurationRecorderAsync(StopConfigurationRecorderRequest request) {
        return this.stopConfigurationRecorderAsync(request, null);
    }

    @Override
    public Future<Void> stopConfigurationRecorderAsync(final StopConfigurationRecorderRequest request, final AsyncHandler<StopConfigurationRecorderRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonConfigAsyncClient.this.stopConfigurationRecorder(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

