/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetachVolumeRequestMarshaller
implements Marshaller<Request<DetachVolumeRequest>, DetachVolumeRequest> {
    @Override
    public Request<DetachVolumeRequest> marshall(DetachVolumeRequest detachVolumeRequest) {
        if (detachVolumeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetachVolumeRequest> request = new DefaultRequest<DetachVolumeRequest>(detachVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "DetachVolume");
        request.addParameter("Version", "2015-10-01");
        if (detachVolumeRequest.getVolumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString(detachVolumeRequest.getVolumeId()));
        }
        if (detachVolumeRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(detachVolumeRequest.getInstanceId()));
        }
        if (detachVolumeRequest.getDevice() != null) {
            request.addParameter("Device", StringUtils.fromString(detachVolumeRequest.getDevice()));
        }
        if (detachVolumeRequest.isForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean(detachVolumeRequest.isForce()));
        }
        return request;
    }
}

