/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputDescriptionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class GlobalSecondaryIndexDescriptionJsonMarshaller {
    private static GlobalSecondaryIndexDescriptionJsonMarshaller instance;

    public void marshall(GlobalSecondaryIndexDescription globalSecondaryIndexDescription, JSONWriter jsonWriter) {
        if (globalSecondaryIndexDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeySchemaElement> keySchemaList;
            jsonWriter.object();
            if (globalSecondaryIndexDescription.getIndexName() != null) {
                jsonWriter.key("IndexName").value(globalSecondaryIndexDescription.getIndexName());
            }
            if ((keySchemaList = globalSecondaryIndexDescription.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (globalSecondaryIndexDescription.getProjection() != null) {
                jsonWriter.key("Projection");
                ProjectionJsonMarshaller.getInstance().marshall(globalSecondaryIndexDescription.getProjection(), jsonWriter);
            }
            if (globalSecondaryIndexDescription.getIndexStatus() != null) {
                jsonWriter.key("IndexStatus").value(globalSecondaryIndexDescription.getIndexStatus());
            }
            if (globalSecondaryIndexDescription.getBackfilling() != null) {
                jsonWriter.key("Backfilling").value(globalSecondaryIndexDescription.getBackfilling());
            }
            if (globalSecondaryIndexDescription.getProvisionedThroughput() != null) {
                jsonWriter.key("ProvisionedThroughput");
                ProvisionedThroughputDescriptionJsonMarshaller.getInstance().marshall(globalSecondaryIndexDescription.getProvisionedThroughput(), jsonWriter);
            }
            if (globalSecondaryIndexDescription.getIndexSizeBytes() != null) {
                jsonWriter.key("IndexSizeBytes").value(globalSecondaryIndexDescription.getIndexSizeBytes());
            }
            if (globalSecondaryIndexDescription.getItemCount() != null) {
                jsonWriter.key("ItemCount").value(globalSecondaryIndexDescription.getItemCount());
            }
            if (globalSecondaryIndexDescription.getIndexArn() != null) {
                jsonWriter.key("IndexArn").value(globalSecondaryIndexDescription.getIndexArn());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GlobalSecondaryIndexDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalSecondaryIndexDescriptionJsonMarshaller();
        }
        return instance;
    }
}

