/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CreateTrafficPolicyInstanceRequestMarshaller
implements Marshaller<Request<CreateTrafficPolicyInstanceRequest>, CreateTrafficPolicyInstanceRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<CreateTrafficPolicyInstanceRequest> marshall(CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) {
        if (createTrafficPolicyInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTrafficPolicyInstanceRequest> request = new DefaultRequest<CreateTrafficPolicyInstanceRequest>(createTrafficPolicyInstanceRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
        xmlWriter.startElement("CreateTrafficPolicyInstanceRequest");
        if (createTrafficPolicyInstanceRequest.getHostedZoneId() != null) {
            xmlWriter.startElement("HostedZoneId").value(createTrafficPolicyInstanceRequest.getHostedZoneId()).endElement();
        }
        if (createTrafficPolicyInstanceRequest.getName() != null) {
            xmlWriter.startElement("Name").value(createTrafficPolicyInstanceRequest.getName()).endElement();
        }
        if (createTrafficPolicyInstanceRequest.getTTL() != null) {
            xmlWriter.startElement("TTL").value(createTrafficPolicyInstanceRequest.getTTL()).endElement();
        }
        if (createTrafficPolicyInstanceRequest.getTrafficPolicyId() != null) {
            xmlWriter.startElement("TrafficPolicyId").value(createTrafficPolicyInstanceRequest.getTrafficPolicyId()).endElement();
        }
        if (createTrafficPolicyInstanceRequest.getTrafficPolicyVersion() != null) {
            xmlWriter.startElement("TrafficPolicyVersion").value(createTrafficPolicyInstanceRequest.getTrafficPolicyVersion()).endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    static {
        String path = "/2013-04-01/trafficpolicyinstance";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

