/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecommerceanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class GenerateDataSetRequestMarshaller
implements Marshaller<Request<GenerateDataSetRequest>, GenerateDataSetRequest> {
    @Override
    public Request<GenerateDataSetRequest> marshall(GenerateDataSetRequest generateDataSetRequest) {
        if (generateDataSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateDataSetRequest> request = new DefaultRequest<GenerateDataSetRequest>(generateDataSetRequest, "AWSMarketplaceCommerceAnalytics");
        request.addHeader("X-Amz-Target", "MarketplaceCommerceAnalytics20150701.GenerateDataSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (generateDataSetRequest.getDataSetType() != null) {
                jsonWriter.key("dataSetType").value(generateDataSetRequest.getDataSetType());
            }
            if (generateDataSetRequest.getDataSetPublicationDate() != null) {
                jsonWriter.key("dataSetPublicationDate").value(generateDataSetRequest.getDataSetPublicationDate());
            }
            if (generateDataSetRequest.getRoleNameArn() != null) {
                jsonWriter.key("roleNameArn").value(generateDataSetRequest.getRoleNameArn());
            }
            if (generateDataSetRequest.getDestinationS3BucketName() != null) {
                jsonWriter.key("destinationS3BucketName").value(generateDataSetRequest.getDestinationS3BucketName());
            }
            if (generateDataSetRequest.getDestinationS3Prefix() != null) {
                jsonWriter.key("destinationS3Prefix").value(generateDataSetRequest.getDestinationS3Prefix());
            }
            if (generateDataSetRequest.getSnsTopicArn() != null) {
                jsonWriter.key("snsTopicArn").value(generateDataSetRequest.getSnsTopicArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

