/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.ListImagesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListImagesRequestMarshaller
implements Marshaller<Request<ListImagesRequest>, ListImagesRequest> {
    @Override
    public Request<ListImagesRequest> marshall(ListImagesRequest listImagesRequest) {
        if (listImagesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListImagesRequest> request = new DefaultRequest<ListImagesRequest>(listImagesRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.ListImages");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listImagesRequest.getRegistryId() != null) {
                jsonWriter.key("registryId").value(listImagesRequest.getRegistryId());
            }
            if (listImagesRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(listImagesRequest.getRepositoryName());
            }
            if (listImagesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listImagesRequest.getNextToken());
            }
            if (listImagesRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value(listImagesRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

