/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteVpcEndpointsRequestMarshaller
implements Marshaller<Request<DeleteVpcEndpointsRequest>, DeleteVpcEndpointsRequest> {
    @Override
    public Request<DeleteVpcEndpointsRequest> marshall(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {
        if (deleteVpcEndpointsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteVpcEndpointsRequest> request = new DefaultRequest<DeleteVpcEndpointsRequest>(deleteVpcEndpointsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteVpcEndpoints");
        request.addParameter("Version", "2015-10-01");
        List<String> vpcEndpointIdsList = deleteVpcEndpointsRequest.getVpcEndpointIds();
        int vpcEndpointIdsListIndex = 1;
        for (String vpcEndpointIdsListValue : vpcEndpointIdsList) {
            if (vpcEndpointIdsListValue != null) {
                request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringUtils.fromString(vpcEndpointIdsListValue));
            }
            ++vpcEndpointIdsListIndex;
        }
        return request;
    }
}

