/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cognitoidentity.model.IdentityDescription;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class IdentityDescriptionJsonMarshaller {
    private static IdentityDescriptionJsonMarshaller instance;

    public void marshall(IdentityDescription identityDescription, JSONWriter jsonWriter) {
        if (identityDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> loginsList;
            jsonWriter.object();
            if (identityDescription.getIdentityId() != null) {
                jsonWriter.key("IdentityId").value(identityDescription.getIdentityId());
            }
            if ((loginsList = identityDescription.getLogins()) != null) {
                jsonWriter.key("Logins");
                jsonWriter.array();
                for (String loginsListValue : loginsList) {
                    if (loginsListValue == null) continue;
                    jsonWriter.value(loginsListValue);
                }
                jsonWriter.endArray();
            }
            if (identityDescription.getCreationDate() != null) {
                jsonWriter.key("CreationDate").value(identityDescription.getCreationDate());
            }
            if (identityDescription.getLastModifiedDate() != null) {
                jsonWriter.key("LastModifiedDate").value(identityDescription.getLastModifiedDate());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IdentityDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IdentityDescriptionJsonMarshaller();
        }
        return instance;
    }
}

