/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateApiKeyRequest;
import com.amazonaws.services.apigateway.model.StageKey;
import com.amazonaws.services.apigateway.model.transform.StageKeyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class CreateApiKeyRequestMarshaller
implements Marshaller<Request<CreateApiKeyRequest>, CreateApiKeyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateApiKeyRequest> marshall(CreateApiKeyRequest createApiKeyRequest) {
        if (createApiKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateApiKeyRequest> request = new DefaultRequest<CreateApiKeyRequest>(createApiKeyRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/apikeys";
        request.setResourcePath(uriResourcePath);
        try {
            List<StageKey> stageKeysList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createApiKeyRequest.getName() != null) {
                jsonWriter.key("name").value(createApiKeyRequest.getName());
            }
            if (createApiKeyRequest.getDescription() != null) {
                jsonWriter.key("description").value(createApiKeyRequest.getDescription());
            }
            if (createApiKeyRequest.getEnabled() != null) {
                jsonWriter.key("enabled").value(createApiKeyRequest.getEnabled());
            }
            if ((stageKeysList = createApiKeyRequest.getStageKeys()) != null) {
                jsonWriter.key("stageKeys");
                jsonWriter.array();
                for (StageKey stageKeysListValue : stageKeysList) {
                    if (stageKeysListValue == null) continue;
                    StageKeyJsonMarshaller.getInstance().marshall(stageKeysListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

