/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.Nameserver;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversRequest;
import com.amazonaws.services.route53domains.model.transform.NameserverJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateDomainNameserversRequestMarshaller
implements Marshaller<Request<UpdateDomainNameserversRequest>, UpdateDomainNameserversRequest> {
    @Override
    public Request<UpdateDomainNameserversRequest> marshall(UpdateDomainNameserversRequest updateDomainNameserversRequest) {
        if (updateDomainNameserversRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDomainNameserversRequest> request = new DefaultRequest<UpdateDomainNameserversRequest>(updateDomainNameserversRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.UpdateDomainNameservers");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList nameserversList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateDomainNameserversRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value(updateDomainNameserversRequest.getDomainName());
            }
            if (updateDomainNameserversRequest.getFIAuthKey() != null) {
                jsonWriter.key("FIAuthKey").value(updateDomainNameserversRequest.getFIAuthKey());
            }
            if (!(nameserversList = (SdkInternalList)updateDomainNameserversRequest.getNameservers()).isEmpty() || !nameserversList.isAutoConstruct()) {
                jsonWriter.key("Nameservers");
                jsonWriter.array();
                for (Nameserver nameserversListValue : nameserversList) {
                    if (nameserversListValue == null) continue;
                    NameserverJsonMarshaller.getInstance().marshall(nameserversListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

