/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.ListContainerInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListContainerInstancesRequestMarshaller
implements Marshaller<Request<ListContainerInstancesRequest>, ListContainerInstancesRequest> {
    @Override
    public Request<ListContainerInstancesRequest> marshall(ListContainerInstancesRequest listContainerInstancesRequest) {
        if (listContainerInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListContainerInstancesRequest> request = new DefaultRequest<ListContainerInstancesRequest>(listContainerInstancesRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.ListContainerInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listContainerInstancesRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(listContainerInstancesRequest.getCluster());
            }
            if (listContainerInstancesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listContainerInstancesRequest.getNextToken());
            }
            if (listContainerInstancesRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value(listContainerInstancesRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

