/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.EnterStandbyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EnterStandbyRequestMarshaller
implements Marshaller<Request<EnterStandbyRequest>, EnterStandbyRequest> {
    @Override
    public Request<EnterStandbyRequest> marshall(EnterStandbyRequest enterStandbyRequest) {
        if (enterStandbyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnterStandbyRequest> request = new DefaultRequest<EnterStandbyRequest>(enterStandbyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "EnterStandby");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList instanceIdsList = (SdkInternalList)enterStandbyRequest.getInstanceIds();
        if (!instanceIdsList.isEmpty() || !instanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (enterStandbyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(enterStandbyRequest.getAutoScalingGroupName()));
        }
        if (enterStandbyRequest.getShouldDecrementDesiredCapacity() != null) {
            request.addParameter("ShouldDecrementDesiredCapacity", StringUtils.fromBoolean(enterStandbyRequest.getShouldDecrementDesiredCapacity()));
        }
        return request;
    }
}

