/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directconnect.model.NewPublicVirtualInterface;
import com.amazonaws.services.directconnect.model.RouteFilterPrefix;
import com.amazonaws.services.directconnect.model.transform.RouteFilterPrefixJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class NewPublicVirtualInterfaceJsonMarshaller {
    private static NewPublicVirtualInterfaceJsonMarshaller instance;

    public void marshall(NewPublicVirtualInterface newPublicVirtualInterface, JSONWriter jsonWriter) {
        if (newPublicVirtualInterface == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList routeFilterPrefixesList;
            jsonWriter.object();
            if (newPublicVirtualInterface.getVirtualInterfaceName() != null) {
                jsonWriter.key("virtualInterfaceName").value(newPublicVirtualInterface.getVirtualInterfaceName());
            }
            if (newPublicVirtualInterface.getVlan() != null) {
                jsonWriter.key("vlan").value(newPublicVirtualInterface.getVlan());
            }
            if (newPublicVirtualInterface.getAsn() != null) {
                jsonWriter.key("asn").value(newPublicVirtualInterface.getAsn());
            }
            if (newPublicVirtualInterface.getAuthKey() != null) {
                jsonWriter.key("authKey").value(newPublicVirtualInterface.getAuthKey());
            }
            if (newPublicVirtualInterface.getAmazonAddress() != null) {
                jsonWriter.key("amazonAddress").value(newPublicVirtualInterface.getAmazonAddress());
            }
            if (newPublicVirtualInterface.getCustomerAddress() != null) {
                jsonWriter.key("customerAddress").value(newPublicVirtualInterface.getCustomerAddress());
            }
            if (!(routeFilterPrefixesList = (SdkInternalList)newPublicVirtualInterface.getRouteFilterPrefixes()).isEmpty() || !routeFilterPrefixesList.isAutoConstruct()) {
                jsonWriter.key("routeFilterPrefixes");
                jsonWriter.array();
                for (RouteFilterPrefix routeFilterPrefixesListValue : routeFilterPrefixesList) {
                    if (routeFilterPrefixesListValue == null) continue;
                    RouteFilterPrefixJsonMarshaller.getInstance().marshall(routeFilterPrefixesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NewPublicVirtualInterfaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NewPublicVirtualInterfaceJsonMarshaller();
        }
        return instance;
    }
}

