/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteModelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteModelRequestMarshaller
implements Marshaller<Request<DeleteModelRequest>, DeleteModelRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteModelRequest> marshall(DeleteModelRequest deleteModelRequest) {
        if (deleteModelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteModelRequest> request = new DefaultRequest<DeleteModelRequest>(deleteModelRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/models/{model_name}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteModelRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteModelRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{model_name}", deleteModelRequest.getModelName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteModelRequest.getModelName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

