/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.workspaces.model.WorkspaceRequest;
import com.amazonaws.util.json.JSONWriter;

public class WorkspaceRequestJsonMarshaller {
    private static WorkspaceRequestJsonMarshaller instance;

    public void marshall(WorkspaceRequest workspaceRequest, JSONWriter jsonWriter) {
        if (workspaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (workspaceRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(workspaceRequest.getDirectoryId());
            }
            if (workspaceRequest.getUserName() != null) {
                jsonWriter.key("UserName").value(workspaceRequest.getUserName());
            }
            if (workspaceRequest.getBundleId() != null) {
                jsonWriter.key("BundleId").value(workspaceRequest.getBundleId());
            }
            if (workspaceRequest.getVolumeEncryptionKey() != null) {
                jsonWriter.key("VolumeEncryptionKey").value(workspaceRequest.getVolumeEncryptionKey());
            }
            if (workspaceRequest.getUserVolumeEncryptionEnabled() != null) {
                jsonWriter.key("UserVolumeEncryptionEnabled").value(workspaceRequest.getUserVolumeEncryptionEnabled());
            }
            if (workspaceRequest.getRootVolumeEncryptionEnabled() != null) {
                jsonWriter.key("RootVolumeEncryptionEnabled").value(workspaceRequest.getRootVolumeEncryptionEnabled());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceRequestJsonMarshaller();
        }
        return instance;
    }
}

