/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.BouncedRecipientInfo;
import com.amazonaws.services.simpleemail.model.ExtensionField;
import com.amazonaws.services.simpleemail.model.MessageDsn;
import com.amazonaws.services.simpleemail.model.RecipientDsnFields;
import com.amazonaws.services.simpleemail.model.SendBounceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SendBounceRequestMarshaller
implements Marshaller<Request<SendBounceRequest>, SendBounceRequest> {
    @Override
    public Request<SendBounceRequest> marshall(SendBounceRequest sendBounceRequest) {
        MessageDsn messageDsnMessageDsn;
        if (sendBounceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendBounceRequest> request = new DefaultRequest<SendBounceRequest>(sendBounceRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendBounce");
        request.addParameter("Version", "2010-12-01");
        if (sendBounceRequest.getOriginalMessageId() != null) {
            request.addParameter("OriginalMessageId", StringUtils.fromString(sendBounceRequest.getOriginalMessageId()));
        }
        if (sendBounceRequest.getBounceSender() != null) {
            request.addParameter("BounceSender", StringUtils.fromString(sendBounceRequest.getBounceSender()));
        }
        if (sendBounceRequest.getExplanation() != null) {
            request.addParameter("Explanation", StringUtils.fromString(sendBounceRequest.getExplanation()));
        }
        if ((messageDsnMessageDsn = sendBounceRequest.getMessageDsn()) != null) {
            if (messageDsnMessageDsn.getReportingMta() != null) {
                request.addParameter("MessageDsn.ReportingMta", StringUtils.fromString(messageDsnMessageDsn.getReportingMta()));
            }
            if (messageDsnMessageDsn.getArrivalDate() != null) {
                request.addParameter("MessageDsn.ArrivalDate", StringUtils.fromDate(messageDsnMessageDsn.getArrivalDate()));
            }
            List<ExtensionField> extensionFieldsList = messageDsnMessageDsn.getExtensionFields();
            int extensionFieldsListIndex = 1;
            for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                ExtensionField extensionFieldMember = extensionFieldsListValue;
                if (extensionFieldMember != null) {
                    if (extensionFieldMember.getName() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString(extensionFieldMember.getName()));
                    }
                    if (extensionFieldMember.getValue() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString(extensionFieldMember.getValue()));
                    }
                }
                ++extensionFieldsListIndex;
            }
        }
        List<BouncedRecipientInfo> bouncedRecipientInfoListList = sendBounceRequest.getBouncedRecipientInfoList();
        int bouncedRecipientInfoListListIndex = 1;
        for (BouncedRecipientInfo bouncedRecipientInfoListListValue : bouncedRecipientInfoListList) {
            BouncedRecipientInfo bouncedRecipientInfoMember = bouncedRecipientInfoListListValue;
            if (bouncedRecipientInfoMember != null) {
                RecipientDsnFields recipientDsnFieldsRecipientDsnFields;
                if (bouncedRecipientInfoMember.getRecipient() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".Recipient", StringUtils.fromString(bouncedRecipientInfoMember.getRecipient()));
                }
                if (bouncedRecipientInfoMember.getRecipientArn() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientArn", StringUtils.fromString(bouncedRecipientInfoMember.getRecipientArn()));
                }
                if (bouncedRecipientInfoMember.getBounceType() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".BounceType", StringUtils.fromString(bouncedRecipientInfoMember.getBounceType()));
                }
                if ((recipientDsnFieldsRecipientDsnFields = bouncedRecipientInfoMember.getRecipientDsnFields()) != null) {
                    if (recipientDsnFieldsRecipientDsnFields.getFinalRecipient() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.FinalRecipient", StringUtils.fromString(recipientDsnFieldsRecipientDsnFields.getFinalRecipient()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getAction() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Action", StringUtils.fromString(recipientDsnFieldsRecipientDsnFields.getAction()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getRemoteMta() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.RemoteMta", StringUtils.fromString(recipientDsnFieldsRecipientDsnFields.getRemoteMta()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getStatus() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Status", StringUtils.fromString(recipientDsnFieldsRecipientDsnFields.getStatus()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getDiagnosticCode() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.DiagnosticCode", StringUtils.fromString(recipientDsnFieldsRecipientDsnFields.getDiagnosticCode()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getLastAttemptDate() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.LastAttemptDate", StringUtils.fromDate(recipientDsnFieldsRecipientDsnFields.getLastAttemptDate()));
                    }
                    List<ExtensionField> extensionFieldsList = recipientDsnFieldsRecipientDsnFields.getExtensionFields();
                    int extensionFieldsListIndex = 1;
                    for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                        ExtensionField extensionFieldMember = extensionFieldsListValue;
                        if (extensionFieldMember != null) {
                            if (extensionFieldMember.getName() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString(extensionFieldMember.getName()));
                            }
                            if (extensionFieldMember.getValue() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString(extensionFieldMember.getValue()));
                            }
                        }
                        ++extensionFieldsListIndex;
                    }
                }
            }
            ++bouncedRecipientInfoListListIndex;
        }
        if (sendBounceRequest.getBounceSenderArn() != null) {
            request.addParameter("BounceSenderArn", StringUtils.fromString(sendBounceRequest.getBounceSenderArn()));
        }
        return request;
    }
}

