/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeAccountAttributesRequestMarshaller
implements Marshaller<Request<DescribeAccountAttributesRequest>, DescribeAccountAttributesRequest> {
    @Override
    public Request<DescribeAccountAttributesRequest> marshall(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        if (describeAccountAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAccountAttributesRequest> request = new DefaultRequest<DescribeAccountAttributesRequest>(describeAccountAttributesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeAccountAttributes");
        request.addParameter("Version", "2015-10-01");
        List<String> attributeNamesList = describeAccountAttributesRequest.getAttributeNames();
        int attributeNamesListIndex = 1;
        for (String attributeNamesListValue : attributeNamesList) {
            if (attributeNamesListValue != null) {
                request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString(attributeNamesListValue));
            }
            ++attributeNamesListIndex;
        }
        return request;
    }
}

