/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codedeploy.model.CreateDeploymentConfigRequest;
import com.amazonaws.services.codedeploy.model.transform.MinimumHealthyHostsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateDeploymentConfigRequestMarshaller
implements Marshaller<Request<CreateDeploymentConfigRequest>, CreateDeploymentConfigRequest> {
    @Override
    public Request<CreateDeploymentConfigRequest> marshall(CreateDeploymentConfigRequest createDeploymentConfigRequest) {
        if (createDeploymentConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeploymentConfigRequest> request = new DefaultRequest<CreateDeploymentConfigRequest>(createDeploymentConfigRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.CreateDeploymentConfig");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDeploymentConfigRequest.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value(createDeploymentConfigRequest.getDeploymentConfigName());
            }
            if (createDeploymentConfigRequest.getMinimumHealthyHosts() != null) {
                jsonWriter.key("minimumHealthyHosts");
                MinimumHealthyHostsJsonMarshaller.getInstance().marshall(createDeploymentConfigRequest.getMinimumHealthyHosts(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

