/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteRestApiRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteRestApiRequestMarshaller
implements Marshaller<Request<DeleteRestApiRequest>, DeleteRestApiRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteRestApiRequest> marshall(DeleteRestApiRequest deleteRestApiRequest) {
        if (deleteRestApiRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteRestApiRequest> request = new DefaultRequest<DeleteRestApiRequest>(deleteRestApiRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteRestApiRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteRestApiRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

