/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionDetail;
import com.amazonaws.services.elasticmapreduce.model.JobFlowDetail;
import com.amazonaws.services.elasticmapreduce.model.StepDetail;
import com.amazonaws.services.elasticmapreduce.model.transform.BootstrapActionDetailJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.JobFlowExecutionStatusDetailJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.JobFlowInstancesDetailJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepDetailJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class JobFlowDetailJsonMarshaller {
    private static JobFlowDetailJsonMarshaller instance;

    public void marshall(JobFlowDetail jobFlowDetail, JSONWriter jsonWriter) {
        if (jobFlowDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList supportedProductsList;
            SdkInternalList bootstrapActionsList;
            SdkInternalList stepsList;
            jsonWriter.object();
            if (jobFlowDetail.getJobFlowId() != null) {
                jsonWriter.key("JobFlowId").value(jobFlowDetail.getJobFlowId());
            }
            if (jobFlowDetail.getName() != null) {
                jsonWriter.key("Name").value(jobFlowDetail.getName());
            }
            if (jobFlowDetail.getLogUri() != null) {
                jsonWriter.key("LogUri").value(jobFlowDetail.getLogUri());
            }
            if (jobFlowDetail.getAmiVersion() != null) {
                jsonWriter.key("AmiVersion").value(jobFlowDetail.getAmiVersion());
            }
            if (jobFlowDetail.getExecutionStatusDetail() != null) {
                jsonWriter.key("ExecutionStatusDetail");
                JobFlowExecutionStatusDetailJsonMarshaller.getInstance().marshall(jobFlowDetail.getExecutionStatusDetail(), jsonWriter);
            }
            if (jobFlowDetail.getInstances() != null) {
                jsonWriter.key("Instances");
                JobFlowInstancesDetailJsonMarshaller.getInstance().marshall(jobFlowDetail.getInstances(), jsonWriter);
            }
            if (!(stepsList = (SdkInternalList)jobFlowDetail.getSteps()).isEmpty() || !stepsList.isAutoConstruct()) {
                jsonWriter.key("Steps");
                jsonWriter.array();
                for (StepDetail stepsListValue : stepsList) {
                    if (stepsListValue == null) continue;
                    StepDetailJsonMarshaller.getInstance().marshall(stepsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(bootstrapActionsList = (SdkInternalList)jobFlowDetail.getBootstrapActions()).isEmpty() || !bootstrapActionsList.isAutoConstruct()) {
                jsonWriter.key("BootstrapActions");
                jsonWriter.array();
                for (BootstrapActionDetail bootstrapActionsListValue : bootstrapActionsList) {
                    if (bootstrapActionsListValue == null) continue;
                    BootstrapActionDetailJsonMarshaller.getInstance().marshall(bootstrapActionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(supportedProductsList = (SdkInternalList)jobFlowDetail.getSupportedProducts()).isEmpty() || !supportedProductsList.isAutoConstruct()) {
                jsonWriter.key("SupportedProducts");
                jsonWriter.array();
                for (String supportedProductsListValue : supportedProductsList) {
                    if (supportedProductsListValue == null) continue;
                    jsonWriter.value(supportedProductsListValue);
                }
                jsonWriter.endArray();
            }
            if (jobFlowDetail.getVisibleToAllUsers() != null) {
                jsonWriter.key("VisibleToAllUsers").value(jobFlowDetail.getVisibleToAllUsers());
            }
            if (jobFlowDetail.getJobFlowRole() != null) {
                jsonWriter.key("JobFlowRole").value(jobFlowDetail.getJobFlowRole());
            }
            if (jobFlowDetail.getServiceRole() != null) {
                jsonWriter.key("ServiceRole").value(jobFlowDetail.getServiceRole());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobFlowDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobFlowDetailJsonMarshaller();
        }
        return instance;
    }
}

