/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.DescribeEcsClustersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeEcsClustersRequestMarshaller
implements Marshaller<Request<DescribeEcsClustersRequest>, DescribeEcsClustersRequest> {
    @Override
    public Request<DescribeEcsClustersRequest> marshall(DescribeEcsClustersRequest describeEcsClustersRequest) {
        if (describeEcsClustersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeEcsClustersRequest> request = new DefaultRequest<DescribeEcsClustersRequest>(describeEcsClustersRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.DescribeEcsClusters";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag ecsClusterArnsList = (ListWithAutoConstructFlag)describeEcsClustersRequest.getEcsClusterArns();
            if (!(ecsClusterArnsList == null || ecsClusterArnsList.isAutoConstruct() && ecsClusterArnsList.isEmpty())) {
                jsonWriter.key("EcsClusterArns");
                jsonWriter.array();
                for (String ecsClusterArnsListValue : ecsClusterArnsList) {
                    if (ecsClusterArnsListValue == null) continue;
                    jsonWriter.value(ecsClusterArnsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeEcsClustersRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(describeEcsClustersRequest.getStackId());
            }
            if (describeEcsClustersRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeEcsClustersRequest.getNextToken());
            }
            if (describeEcsClustersRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value(describeEcsClustersRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

