/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.Evaluation;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PutEvaluationsRequestMarshaller
implements Marshaller<Request<PutEvaluationsRequest>, PutEvaluationsRequest> {
    @Override
    public Request<PutEvaluationsRequest> marshall(PutEvaluationsRequest putEvaluationsRequest) {
        if (putEvaluationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutEvaluationsRequest> request = new DefaultRequest<PutEvaluationsRequest>(putEvaluationsRequest, "AmazonConfig");
        String target = "StarlingDoveService.PutEvaluations";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag evaluationsList = (ListWithAutoConstructFlag)putEvaluationsRequest.getEvaluations();
            if (!(evaluationsList == null || evaluationsList.isAutoConstruct() && evaluationsList.isEmpty())) {
                jsonWriter.key("Evaluations");
                jsonWriter.array();
                for (Evaluation evaluationsListValue : evaluationsList) {
                    if (evaluationsListValue == null) continue;
                    jsonWriter.object();
                    if (evaluationsListValue.getComplianceResourceType() != null) {
                        jsonWriter.key("ComplianceResourceType").value(evaluationsListValue.getComplianceResourceType());
                    }
                    if (evaluationsListValue.getComplianceResourceId() != null) {
                        jsonWriter.key("ComplianceResourceId").value(evaluationsListValue.getComplianceResourceId());
                    }
                    if (evaluationsListValue.getComplianceType() != null) {
                        jsonWriter.key("ComplianceType").value(evaluationsListValue.getComplianceType());
                    }
                    if (evaluationsListValue.getAnnotation() != null) {
                        jsonWriter.key("Annotation").value(evaluationsListValue.getAnnotation());
                    }
                    if (evaluationsListValue.getOrderingTimestamp() != null) {
                        jsonWriter.key("OrderingTimestamp").value(evaluationsListValue.getOrderingTimestamp());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (putEvaluationsRequest.getResultToken() != null) {
                jsonWriter.key("ResultToken").value(putEvaluationsRequest.getResultToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

