/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.ConfigRule;
import com.amazonaws.services.config.model.PutConfigRuleRequest;
import com.amazonaws.services.config.model.Scope;
import com.amazonaws.services.config.model.Source;
import com.amazonaws.services.config.model.SourceDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PutConfigRuleRequestMarshaller
implements Marshaller<Request<PutConfigRuleRequest>, PutConfigRuleRequest> {
    @Override
    public Request<PutConfigRuleRequest> marshall(PutConfigRuleRequest putConfigRuleRequest) {
        if (putConfigRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutConfigRuleRequest> request = new DefaultRequest<PutConfigRuleRequest>(putConfigRuleRequest, "AmazonConfig");
        String target = "StarlingDoveService.PutConfigRule";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ConfigRule configRule = putConfigRuleRequest.getConfigRule();
            if (configRule != null) {
                Source source;
                Scope scope;
                jsonWriter.key("ConfigRule");
                jsonWriter.object();
                if (configRule.getConfigRuleName() != null) {
                    jsonWriter.key("ConfigRuleName").value(configRule.getConfigRuleName());
                }
                if (configRule.getConfigRuleArn() != null) {
                    jsonWriter.key("ConfigRuleArn").value(configRule.getConfigRuleArn());
                }
                if (configRule.getConfigRuleId() != null) {
                    jsonWriter.key("ConfigRuleId").value(configRule.getConfigRuleId());
                }
                if (configRule.getDescription() != null) {
                    jsonWriter.key("Description").value(configRule.getDescription());
                }
                if ((scope = configRule.getScope()) != null) {
                    jsonWriter.key("Scope");
                    jsonWriter.object();
                    ListWithAutoConstructFlag complianceResourceTypesList = (ListWithAutoConstructFlag)scope.getComplianceResourceTypes();
                    if (!(complianceResourceTypesList == null || complianceResourceTypesList.isAutoConstruct() && complianceResourceTypesList.isEmpty())) {
                        jsonWriter.key("ComplianceResourceTypes");
                        jsonWriter.array();
                        for (String complianceResourceTypesListValue : complianceResourceTypesList) {
                            if (complianceResourceTypesListValue == null) continue;
                            jsonWriter.value(complianceResourceTypesListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (scope.getTagKey() != null) {
                        jsonWriter.key("TagKey").value(scope.getTagKey());
                    }
                    if (scope.getTagValue() != null) {
                        jsonWriter.key("TagValue").value(scope.getTagValue());
                    }
                    if (scope.getComplianceResourceId() != null) {
                        jsonWriter.key("ComplianceResourceId").value(scope.getComplianceResourceId());
                    }
                    jsonWriter.endObject();
                }
                if ((source = configRule.getSource()) != null) {
                    ListWithAutoConstructFlag sourceDetailsList;
                    jsonWriter.key("Source");
                    jsonWriter.object();
                    if (source.getOwner() != null) {
                        jsonWriter.key("Owner").value(source.getOwner());
                    }
                    if (source.getSourceIdentifier() != null) {
                        jsonWriter.key("SourceIdentifier").value(source.getSourceIdentifier());
                    }
                    if (!((sourceDetailsList = (ListWithAutoConstructFlag)source.getSourceDetails()) == null || sourceDetailsList.isAutoConstruct() && sourceDetailsList.isEmpty())) {
                        jsonWriter.key("SourceDetails");
                        jsonWriter.array();
                        for (SourceDetail sourceDetailsListValue : sourceDetailsList) {
                            if (sourceDetailsListValue == null) continue;
                            jsonWriter.object();
                            if (sourceDetailsListValue.getEventSource() != null) {
                                jsonWriter.key("EventSource").value(sourceDetailsListValue.getEventSource());
                            }
                            if (sourceDetailsListValue.getMessageType() != null) {
                                jsonWriter.key("MessageType").value(sourceDetailsListValue.getMessageType());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if (configRule.getInputParameters() != null) {
                    jsonWriter.key("InputParameters").value(configRule.getInputParameters());
                }
                if (configRule.getMaximumExecutionFrequency() != null) {
                    jsonWriter.key("MaximumExecutionFrequency").value(configRule.getMaximumExecutionFrequency());
                }
                if (configRule.getConfigRuleState() != null) {
                    jsonWriter.key("ConfigRuleState").value(configRule.getConfigRuleState());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

