/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.config.AmazonConfig;
import com.amazonaws.services.config.model.DeleteConfigRuleRequest;
import com.amazonaws.services.config.model.DeleteDeliveryChannelRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotResult;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleRequest;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleResult;
import com.amazonaws.services.config.model.DescribeComplianceByResourceRequest;
import com.amazonaws.services.config.model.DescribeComplianceByResourceResult;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusResult;
import com.amazonaws.services.config.model.DescribeConfigRulesRequest;
import com.amazonaws.services.config.model.DescribeConfigRulesResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeResult;
import com.amazonaws.services.config.model.GetResourceConfigHistoryRequest;
import com.amazonaws.services.config.model.GetResourceConfigHistoryResult;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.services.config.model.ListDiscoveredResourcesResult;
import com.amazonaws.services.config.model.PutConfigRuleRequest;
import com.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.PutEvaluationsResult;
import com.amazonaws.services.config.model.StartConfigurationRecorderRequest;
import com.amazonaws.services.config.model.StopConfigurationRecorderRequest;
import com.amazonaws.services.config.model.transform.DeleteConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.DeleteDeliveryChannelRequestMarshaller;
import com.amazonaws.services.config.model.transform.DeliverConfigSnapshotRequestMarshaller;
import com.amazonaws.services.config.model.transform.DeliverConfigSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByConfigRuleResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByResourceRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByResourceResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRuleEvaluationStatusResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRulesRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRulesResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecorderStatusResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecordersRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecordersResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelStatusResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelsRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelsResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByConfigRuleResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByResourceRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByResourceResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByConfigRuleResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByResourceTypeResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetResourceConfigHistoryRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetResourceConfigHistoryResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.InsufficientDeliveryPolicyExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidConfigurationRecorderNameExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidDeliveryChannelNameExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidLimitExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidRecordingGroupExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidResultTokenExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidRoleExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidS3KeyPrefixExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidSNSTopicARNExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.InvalidTimeRangeExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.LastDeliveryChannelDeleteFailedExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.ListDiscoveredResourcesRequestMarshaller;
import com.amazonaws.services.config.model.transform.ListDiscoveredResourcesResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.MaxNumberOfConfigRulesExceededExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.MaxNumberOfConfigurationRecordersExceededExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.MaxNumberOfDeliveryChannelsExceededExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.NoAvailableConfigurationRecorderExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.NoAvailableDeliveryChannelExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.NoRunningConfigurationRecorderExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.NoSuchBucketExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.NoSuchConfigRuleExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.NoSuchConfigurationRecorderExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.NoSuchDeliveryChannelExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.PutConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutConfigurationRecorderRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutDeliveryChannelRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutEvaluationsRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutEvaluationsResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.ResourceNotDiscoveredExceptionUnmarshaller;
import com.amazonaws.services.config.model.transform.StartConfigurationRecorderRequestMarshaller;
import com.amazonaws.services.config.model.transform.StopConfigurationRecorderRequestMarshaller;
import com.amazonaws.services.config.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonConfigClient
extends AmazonWebServiceClient
implements AmazonConfig {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonConfig.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonConfigClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonConfigClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonConfigClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonConfigClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonConfigClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonConfigClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonConfigClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonConfigClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonConfigClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotDiscoveredExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoSuchConfigurationRecorderExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoSuchConfigRuleExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MaxNumberOfConfigurationRecordersExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LastDeliveryChannelDeleteFailedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidSNSTopicARNExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidConfigurationRecorderNameExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoAvailableConfigurationRecorderExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MaxNumberOfConfigRulesExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoSuchDeliveryChannelExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidRecordingGroupExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MaxNumberOfDeliveryChannelsExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidTimeRangeExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidLimitExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidDeliveryChannelNameExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidResultTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InsufficientDeliveryPolicyExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoRunningConfigurationRecorderExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoSuchBucketExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ValidationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidS3KeyPrefixExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidRoleExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoAvailableDeliveryChannelExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("config.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/config/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/config/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceDetailsByResourceResult getComplianceDetailsByResource(GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceDetailsByResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceDetailsByResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceDetailsByResourceRequestMarshaller().marshall(super.beforeMarshalling(getComplianceDetailsByResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetComplianceDetailsByResourceResultJsonUnmarshaller unmarshaller = new GetComplianceDetailsByResourceResultJsonUnmarshaller();
            JsonResponseHandler<GetComplianceDetailsByResourceResult> responseHandler = new JsonResponseHandler<GetComplianceDetailsByResourceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetComplianceDetailsByResourceResult getComplianceDetailsByResourceResult = (GetComplianceDetailsByResourceResult)response.getAwsResponse();
            return getComplianceDetailsByResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEvaluationsResult putEvaluations(PutEvaluationsRequest putEvaluationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEvaluationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEvaluationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEvaluationsRequestMarshaller().marshall(super.beforeMarshalling(putEvaluationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            PutEvaluationsResultJsonUnmarshaller unmarshaller = new PutEvaluationsResultJsonUnmarshaller();
            JsonResponseHandler<PutEvaluationsResult> responseHandler = new JsonResponseHandler<PutEvaluationsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            PutEvaluationsResult putEvaluationsResult = (PutEvaluationsResult)response.getAwsResponse();
            return putEvaluationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceSummaryByConfigRuleResult getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceSummaryByConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceSummaryByConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceSummaryByConfigRuleRequestMarshaller().marshall(super.beforeMarshalling(getComplianceSummaryByConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetComplianceSummaryByConfigRuleResultJsonUnmarshaller unmarshaller = new GetComplianceSummaryByConfigRuleResultJsonUnmarshaller();
            JsonResponseHandler<GetComplianceSummaryByConfigRuleResult> responseHandler = new JsonResponseHandler<GetComplianceSummaryByConfigRuleResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetComplianceSummaryByConfigRuleResult getComplianceSummaryByConfigRuleResult = (GetComplianceSummaryByConfigRuleResult)response.getAwsResponse();
            return getComplianceSummaryByConfigRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceSummaryByResourceTypeResult getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceSummaryByResourceTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceSummaryByResourceTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceSummaryByResourceTypeRequestMarshaller().marshall(super.beforeMarshalling(getComplianceSummaryByResourceTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetComplianceSummaryByResourceTypeResultJsonUnmarshaller unmarshaller = new GetComplianceSummaryByResourceTypeResultJsonUnmarshaller();
            JsonResponseHandler<GetComplianceSummaryByResourceTypeResult> responseHandler = new JsonResponseHandler<GetComplianceSummaryByResourceTypeResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetComplianceSummaryByResourceTypeResult getComplianceSummaryByResourceTypeResult = (GetComplianceSummaryByResourceTypeResult)response.getAwsResponse();
            return getComplianceSummaryByResourceTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeComplianceByConfigRuleResult describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComplianceByConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComplianceByConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComplianceByConfigRuleRequestMarshaller().marshall(super.beforeMarshalling(describeComplianceByConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeComplianceByConfigRuleResultJsonUnmarshaller unmarshaller = new DescribeComplianceByConfigRuleResultJsonUnmarshaller();
            JsonResponseHandler<DescribeComplianceByConfigRuleResult> responseHandler = new JsonResponseHandler<DescribeComplianceByConfigRuleResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeComplianceByConfigRuleResult describeComplianceByConfigRuleResult = (DescribeComplianceByConfigRuleResult)response.getAwsResponse();
            return describeComplianceByConfigRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startConfigurationRecorder(StartConfigurationRecorderRequest startConfigurationRecorderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startConfigurationRecorderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartConfigurationRecorderRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartConfigurationRecorderRequestMarshaller().marshall(super.beforeMarshalling(startConfigurationRecorderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putDeliveryChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutDeliveryChannelRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutDeliveryChannelRequestMarshaller().marshall(super.beforeMarshalling(putDeliveryChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceDetailsByConfigRuleResult getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceDetailsByConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceDetailsByConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceDetailsByConfigRuleRequestMarshaller().marshall(super.beforeMarshalling(getComplianceDetailsByConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetComplianceDetailsByConfigRuleResultJsonUnmarshaller unmarshaller = new GetComplianceDetailsByConfigRuleResultJsonUnmarshaller();
            JsonResponseHandler<GetComplianceDetailsByConfigRuleResult> responseHandler = new JsonResponseHandler<GetComplianceDetailsByConfigRuleResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetComplianceDetailsByConfigRuleResult getComplianceDetailsByConfigRuleResult = (GetComplianceDetailsByConfigRuleResult)response.getAwsResponse();
            return getComplianceDetailsByConfigRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigRuleEvaluationStatusResult describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigRuleEvaluationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigRuleEvaluationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigRuleEvaluationStatusRequestMarshaller().marshall(super.beforeMarshalling(describeConfigRuleEvaluationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeConfigRuleEvaluationStatusResultJsonUnmarshaller unmarshaller = new DescribeConfigRuleEvaluationStatusResultJsonUnmarshaller();
            JsonResponseHandler<DescribeConfigRuleEvaluationStatusResult> responseHandler = new JsonResponseHandler<DescribeConfigRuleEvaluationStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConfigRuleEvaluationStatusResult describeConfigRuleEvaluationStatusResult = (DescribeConfigRuleEvaluationStatusResult)response.getAwsResponse();
            return describeConfigRuleEvaluationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeliveryChannelsResult describeDeliveryChannels(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDeliveryChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDeliveryChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDeliveryChannelsRequestMarshaller().marshall(super.beforeMarshalling(describeDeliveryChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeDeliveryChannelsResultJsonUnmarshaller unmarshaller = new DescribeDeliveryChannelsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeDeliveryChannelsResult> responseHandler = new JsonResponseHandler<DescribeDeliveryChannelsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDeliveryChannelsResult describeDeliveryChannelsResult = (DescribeDeliveryChannelsResult)response.getAwsResponse();
            return describeDeliveryChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeliveryChannelStatusResult describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDeliveryChannelStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDeliveryChannelStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDeliveryChannelStatusRequestMarshaller().marshall(super.beforeMarshalling(describeDeliveryChannelStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeDeliveryChannelStatusResultJsonUnmarshaller unmarshaller = new DescribeDeliveryChannelStatusResultJsonUnmarshaller();
            JsonResponseHandler<DescribeDeliveryChannelStatusResult> responseHandler = new JsonResponseHandler<DescribeDeliveryChannelStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDeliveryChannelStatusResult describeDeliveryChannelStatusResult = (DescribeDeliveryChannelStatusResult)response.getAwsResponse();
            return describeDeliveryChannelStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationRecordersResult describeConfigurationRecorders(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationRecordersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigurationRecordersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigurationRecordersRequestMarshaller().marshall(super.beforeMarshalling(describeConfigurationRecordersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeConfigurationRecordersResultJsonUnmarshaller unmarshaller = new DescribeConfigurationRecordersResultJsonUnmarshaller();
            JsonResponseHandler<DescribeConfigurationRecordersResult> responseHandler = new JsonResponseHandler<DescribeConfigurationRecordersResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConfigurationRecordersResult describeConfigurationRecordersResult = (DescribeConfigurationRecordersResult)response.getAwsResponse();
            return describeConfigurationRecordersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putConfigRule(PutConfigRuleRequest putConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutConfigRuleRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutConfigRuleRequestMarshaller().marshall(super.beforeMarshalling(putConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConfigRuleRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConfigRuleRequestMarshaller().marshall(super.beforeMarshalling(deleteConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDeliveryChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDeliveryChannelRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDeliveryChannelRequestMarshaller().marshall(super.beforeMarshalling(deleteDeliveryChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigRulesResult describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigRulesRequestMarshaller().marshall(super.beforeMarshalling(describeConfigRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeConfigRulesResultJsonUnmarshaller unmarshaller = new DescribeConfigRulesResultJsonUnmarshaller();
            JsonResponseHandler<DescribeConfigRulesResult> responseHandler = new JsonResponseHandler<DescribeConfigRulesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConfigRulesResult describeConfigRulesResult = (DescribeConfigRulesResult)response.getAwsResponse();
            return describeConfigRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopConfigurationRecorder(StopConfigurationRecorderRequest stopConfigurationRecorderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopConfigurationRecorderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopConfigurationRecorderRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopConfigurationRecorderRequestMarshaller().marshall(super.beforeMarshalling(stopConfigurationRecorderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeliverConfigSnapshotResult deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deliverConfigSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeliverConfigSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeliverConfigSnapshotRequestMarshaller().marshall(super.beforeMarshalling(deliverConfigSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeliverConfigSnapshotResultJsonUnmarshaller unmarshaller = new DeliverConfigSnapshotResultJsonUnmarshaller();
            JsonResponseHandler<DeliverConfigSnapshotResult> responseHandler = new JsonResponseHandler<DeliverConfigSnapshotResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeliverConfigSnapshotResult deliverConfigSnapshotResult = (DeliverConfigSnapshotResult)response.getAwsResponse();
            return deliverConfigSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putConfigurationRecorder(PutConfigurationRecorderRequest putConfigurationRecorderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putConfigurationRecorderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutConfigurationRecorderRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutConfigurationRecorderRequestMarshaller().marshall(super.beforeMarshalling(putConfigurationRecorderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeComplianceByResourceResult describeComplianceByResource(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComplianceByResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComplianceByResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComplianceByResourceRequestMarshaller().marshall(super.beforeMarshalling(describeComplianceByResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeComplianceByResourceResultJsonUnmarshaller unmarshaller = new DescribeComplianceByResourceResultJsonUnmarshaller();
            JsonResponseHandler<DescribeComplianceByResourceResult> responseHandler = new JsonResponseHandler<DescribeComplianceByResourceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeComplianceByResourceResult describeComplianceByResourceResult = (DescribeComplianceByResourceResult)response.getAwsResponse();
            return describeComplianceByResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceConfigHistoryResult getResourceConfigHistory(GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceConfigHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceConfigHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceConfigHistoryRequestMarshaller().marshall(super.beforeMarshalling(getResourceConfigHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetResourceConfigHistoryResultJsonUnmarshaller unmarshaller = new GetResourceConfigHistoryResultJsonUnmarshaller();
            JsonResponseHandler<GetResourceConfigHistoryResult> responseHandler = new JsonResponseHandler<GetResourceConfigHistoryResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceConfigHistoryResult getResourceConfigHistoryResult = (GetResourceConfigHistoryResult)response.getAwsResponse();
            return getResourceConfigHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDiscoveredResourcesResult listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDiscoveredResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDiscoveredResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDiscoveredResourcesRequestMarshaller().marshall(super.beforeMarshalling(listDiscoveredResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListDiscoveredResourcesResultJsonUnmarshaller unmarshaller = new ListDiscoveredResourcesResultJsonUnmarshaller();
            JsonResponseHandler<ListDiscoveredResourcesResult> responseHandler = new JsonResponseHandler<ListDiscoveredResourcesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListDiscoveredResourcesResult listDiscoveredResourcesResult = (ListDiscoveredResourcesResult)response.getAwsResponse();
            return listDiscoveredResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationRecorderStatusResult describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationRecorderStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigurationRecorderStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigurationRecorderStatusRequestMarshaller().marshall(super.beforeMarshalling(describeConfigurationRecorderStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeConfigurationRecorderStatusResultJsonUnmarshaller unmarshaller = new DescribeConfigurationRecorderStatusResultJsonUnmarshaller();
            JsonResponseHandler<DescribeConfigurationRecorderStatusResult> responseHandler = new JsonResponseHandler<DescribeConfigurationRecorderStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConfigurationRecorderStatusResult describeConfigurationRecorderStatusResult = (DescribeConfigurationRecorderStatusResult)response.getAwsResponse();
            return describeConfigurationRecorderStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public GetComplianceSummaryByConfigRuleResult getComplianceSummaryByConfigRule() throws AmazonServiceException, AmazonClientException {
        return this.getComplianceSummaryByConfigRule(new GetComplianceSummaryByConfigRuleRequest());
    }

    @Override
    public GetComplianceSummaryByResourceTypeResult getComplianceSummaryByResourceType() throws AmazonServiceException, AmazonClientException {
        return this.getComplianceSummaryByResourceType(new GetComplianceSummaryByResourceTypeRequest());
    }

    @Override
    public DescribeComplianceByConfigRuleResult describeComplianceByConfigRule() throws AmazonServiceException, AmazonClientException {
        return this.describeComplianceByConfigRule(new DescribeComplianceByConfigRuleRequest());
    }

    @Override
    public DescribeConfigRuleEvaluationStatusResult describeConfigRuleEvaluationStatus() throws AmazonServiceException, AmazonClientException {
        return this.describeConfigRuleEvaluationStatus(new DescribeConfigRuleEvaluationStatusRequest());
    }

    @Override
    public DescribeDeliveryChannelsResult describeDeliveryChannels() throws AmazonServiceException, AmazonClientException {
        return this.describeDeliveryChannels(new DescribeDeliveryChannelsRequest());
    }

    @Override
    public DescribeDeliveryChannelStatusResult describeDeliveryChannelStatus() throws AmazonServiceException, AmazonClientException {
        return this.describeDeliveryChannelStatus(new DescribeDeliveryChannelStatusRequest());
    }

    @Override
    public DescribeConfigurationRecordersResult describeConfigurationRecorders() throws AmazonServiceException, AmazonClientException {
        return this.describeConfigurationRecorders(new DescribeConfigurationRecordersRequest());
    }

    @Override
    public DescribeConfigRulesResult describeConfigRules() throws AmazonServiceException, AmazonClientException {
        return this.describeConfigRules(new DescribeConfigRulesRequest());
    }

    @Override
    public DescribeComplianceByResourceResult describeComplianceByResource() throws AmazonServiceException, AmazonClientException {
        return this.describeComplianceByResource(new DescribeComplianceByResourceRequest());
    }

    @Override
    public DescribeConfigurationRecorderStatusResult describeConfigurationRecorderStatus() throws AmazonServiceException, AmazonClientException {
        return this.describeConfigurationRecorderStatus(new DescribeConfigurationRecorderStatusRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

