/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudtrail.model.ListTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListTagsRequestMarshaller
implements Marshaller<Request<ListTagsRequest>, ListTagsRequest> {
    @Override
    public Request<ListTagsRequest> marshall(ListTagsRequest listTagsRequest) {
        if (listTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTagsRequest> request = new DefaultRequest<ListTagsRequest>(listTagsRequest, "AWSCloudTrail");
        String target = "CloudTrail_20131101.ListTags";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag resourceIdListList = (ListWithAutoConstructFlag)listTagsRequest.getResourceIdList();
            if (!(resourceIdListList == null || resourceIdListList.isAutoConstruct() && resourceIdListList.isEmpty())) {
                jsonWriter.key("ResourceIdList");
                jsonWriter.array();
                for (String resourceIdListListValue : resourceIdListList) {
                    if (resourceIdListListValue == null) continue;
                    jsonWriter.value(resourceIdListListValue);
                }
                jsonWriter.endArray();
            }
            if (listTagsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(listTagsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

