/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateTrailRequestMarshaller
implements Marshaller<Request<CreateTrailRequest>, CreateTrailRequest> {
    @Override
    public Request<CreateTrailRequest> marshall(CreateTrailRequest createTrailRequest) {
        if (createTrailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTrailRequest> request = new DefaultRequest<CreateTrailRequest>(createTrailRequest, "AWSCloudTrail");
        String target = "CloudTrail_20131101.CreateTrail";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createTrailRequest.getName() != null) {
                jsonWriter.key("Name").value(createTrailRequest.getName());
            }
            if (createTrailRequest.getS3BucketName() != null) {
                jsonWriter.key("S3BucketName").value(createTrailRequest.getS3BucketName());
            }
            if (createTrailRequest.getS3KeyPrefix() != null) {
                jsonWriter.key("S3KeyPrefix").value(createTrailRequest.getS3KeyPrefix());
            }
            if (createTrailRequest.getSnsTopicName() != null) {
                jsonWriter.key("SnsTopicName").value(createTrailRequest.getSnsTopicName());
            }
            if (createTrailRequest.isIncludeGlobalServiceEvents() != null) {
                jsonWriter.key("IncludeGlobalServiceEvents").value(createTrailRequest.isIncludeGlobalServiceEvents());
            }
            if (createTrailRequest.isEnableLogFileValidation() != null) {
                jsonWriter.key("EnableLogFileValidation").value(createTrailRequest.isEnableLogFileValidation());
            }
            if (createTrailRequest.getCloudWatchLogsLogGroupArn() != null) {
                jsonWriter.key("CloudWatchLogsLogGroupArn").value(createTrailRequest.getCloudWatchLogsLogGroupArn());
            }
            if (createTrailRequest.getCloudWatchLogsRoleArn() != null) {
                jsonWriter.key("CloudWatchLogsRoleArn").value(createTrailRequest.getCloudWatchLogsRoleArn());
            }
            if (createTrailRequest.getKmsKeyId() != null) {
                jsonWriter.key("KmsKeyId").value(createTrailRequest.getKmsKeyId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

