/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.AccountLimit;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AccountLimitStaxUnmarshaller
implements Unmarshaller<AccountLimit, StaxUnmarshallerContext> {
    private static AccountLimitStaxUnmarshaller instance;

    @Override
    public AccountLimit unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccountLimit accountLimit = new AccountLimit();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return accountLimit;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    accountLimit.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                accountLimit.setValue(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return accountLimit;
    }

    public static AccountLimitStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AccountLimitStaxUnmarshaller();
        }
        return instance;
    }
}

