/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.elasticbeanstalk.model;

/**
 * 
 */
public enum EnvironmentHealthStatus {

    NoData("NoData"),
    Unknown("Unknown"),
    Pending("Pending"),
    Ok("Ok"),
    Info("Info"),
    Warning("Warning"),
    Degraded("Degraded"),
    Severe("Severe");

    private String value;

    private EnvironmentHealthStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return EnvironmentHealthStatus corresponding to the value
     */
    public static EnvironmentHealthStatus fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        } else if ("NoData".equals(value)) {
            return NoData;
        } else if ("Unknown".equals(value)) {
            return Unknown;
        } else if ("Pending".equals(value)) {
            return Pending;
        } else if ("Ok".equals(value)) {
            return Ok;
        } else if ("Info".equals(value)) {
            return Info;
        } else if ("Warning".equals(value)) {
            return Warning;
        } else if ("Degraded".equals(value)) {
            return Degraded;
        } else if ("Severe".equals(value)) {
            return Severe;
        } else {
            throw new IllegalArgumentException("Cannot create enum from "
                    + value + " value!");
        }
    }
}