/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.config.model;

import java.io.Serializable;

/**
 * <p>
 * Indicates whether an AWS Config rule is compliant. A rule is compliant
 * if all of the resources that the rule evaluated comply with it, and it
 * is noncompliant if any of these resources do not comply.
 * </p>
 */
public class ComplianceByConfigRule implements Serializable, Cloneable {

    /**
     * The name of the AWS Config rule.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 64<br/>
     */
    private String configRuleName;

    /**
     * Indicates whether the AWS Config rule is compliant.
     */
    private Compliance compliance;

    /**
     * The name of the AWS Config rule.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 64<br/>
     *
     * @return The name of the AWS Config rule.
     */
    public String getConfigRuleName() {
        return configRuleName;
    }
    
    /**
     * The name of the AWS Config rule.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 64<br/>
     *
     * @param configRuleName The name of the AWS Config rule.
     */
    public void setConfigRuleName(String configRuleName) {
        this.configRuleName = configRuleName;
    }
    
    /**
     * The name of the AWS Config rule.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 64<br/>
     *
     * @param configRuleName The name of the AWS Config rule.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public ComplianceByConfigRule withConfigRuleName(String configRuleName) {
        this.configRuleName = configRuleName;
        return this;
    }

    /**
     * Indicates whether the AWS Config rule is compliant.
     *
     * @return Indicates whether the AWS Config rule is compliant.
     */
    public Compliance getCompliance() {
        return compliance;
    }
    
    /**
     * Indicates whether the AWS Config rule is compliant.
     *
     * @param compliance Indicates whether the AWS Config rule is compliant.
     */
    public void setCompliance(Compliance compliance) {
        this.compliance = compliance;
    }
    
    /**
     * Indicates whether the AWS Config rule is compliant.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param compliance Indicates whether the AWS Config rule is compliant.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public ComplianceByConfigRule withCompliance(Compliance compliance) {
        this.compliance = compliance;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getConfigRuleName() != null) sb.append("ConfigRuleName: " + getConfigRuleName() + ",");
        if (getCompliance() != null) sb.append("Compliance: " + getCompliance() );
        sb.append("}");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;
        
        hashCode = prime * hashCode + ((getConfigRuleName() == null) ? 0 : getConfigRuleName().hashCode()); 
        hashCode = prime * hashCode + ((getCompliance() == null) ? 0 : getCompliance().hashCode()); 
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;

        if (obj instanceof ComplianceByConfigRule == false) return false;
        ComplianceByConfigRule other = (ComplianceByConfigRule)obj;
        
        if (other.getConfigRuleName() == null ^ this.getConfigRuleName() == null) return false;
        if (other.getConfigRuleName() != null && other.getConfigRuleName().equals(this.getConfigRuleName()) == false) return false; 
        if (other.getCompliance() == null ^ this.getCompliance() == null) return false;
        if (other.getCompliance() != null && other.getCompliance().equals(this.getCompliance()) == false) return false; 
        return true;
    }
    
    @Override
    public ComplianceByConfigRule clone() {
        try {
            return (ComplianceByConfigRule) super.clone();
        
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                    + "even though we're Cloneable!",
                    e);
        }
        
    }

}
    