/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.codepipeline.model;

import java.io.Serializable;

/**
 * 
 */
public class EncryptionKey implements Serializable, Cloneable {

    private String id;

    private String type;

    /**
     * Sets the value of the Id property for this object.
     * 
     * @param id
     *        The new value for the Id property for this object.
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Sets the value of the Id property for this object.
     * 
     * @param id
     *        The new value for the Id property for this object.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public EncryptionKey withId(String id) {
        setId(id);
        return this;
    }

    /**
     * Sets the value of the Type property for this object.
     * 
     * @param type
     *        The new value for the Type property for this object.
     * @see EncryptionKeyType
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Returns the value of the Type property for this object.
     * 
     * @return The value of the Type property for this object.
     * @see EncryptionKeyType
     */
    public String getType() {
        return this.type;
    }

    /**
     * Sets the value of the Type property for this object.
     * 
     * @param type
     *        The new value for the Type property for this object.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EncryptionKeyType
     */
    public EncryptionKey withType(String type) {
        setType(type);
        return this;
    }

    /**
     * Sets the value of the Type property for this object.
     * 
     * @param type
     *        The new value for the Type property for this object.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EncryptionKeyType
     */
    public void setType(EncryptionKeyType type) {
        this.type = type.toString();
    }

    /**
     * Sets the value of the Type property for this object.
     * 
     * @param type
     *        The new value for the Type property for this object.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EncryptionKeyType
     */
    public EncryptionKey withType(EncryptionKeyType type) {
        setType(type);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: " + getId() + ",");
        if (getType() != null)
            sb.append("Type: " + getType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EncryptionKey == false)
            return false;
        EncryptionKey other = (EncryptionKey) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null
                && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null
                && other.getType().equals(this.getType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode
                + ((getType() == null) ? 0 : getType().hashCode());
        return hashCode;
    }

    @Override
    public EncryptionKey clone() {
        try {
            return (EncryptionKey) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}