/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationStatus;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateAssociationStatusRequestMarshaller
implements Marshaller<Request<UpdateAssociationStatusRequest>, UpdateAssociationStatusRequest> {
    @Override
    public Request<UpdateAssociationStatusRequest> marshall(UpdateAssociationStatusRequest updateAssociationStatusRequest) {
        if (updateAssociationStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateAssociationStatusRequest> request = new DefaultRequest<UpdateAssociationStatusRequest>(updateAssociationStatusRequest, "AWSSimpleSystemsManagement");
        String target = "AmazonSSM.UpdateAssociationStatus";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            AssociationStatus associationStatus;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateAssociationStatusRequest.getName() != null) {
                jsonWriter.key("Name").value(updateAssociationStatusRequest.getName());
            }
            if (updateAssociationStatusRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(updateAssociationStatusRequest.getInstanceId());
            }
            if ((associationStatus = updateAssociationStatusRequest.getAssociationStatus()) != null) {
                jsonWriter.key("AssociationStatus");
                jsonWriter.object();
                if (associationStatus.getDate() != null) {
                    jsonWriter.key("Date").value(associationStatus.getDate());
                }
                if (associationStatus.getName() != null) {
                    jsonWriter.key("Name").value(associationStatus.getName());
                }
                if (associationStatus.getMessage() != null) {
                    jsonWriter.key("Message").value(associationStatus.getMessage());
                }
                if (associationStatus.getAdditionalInfo() != null) {
                    jsonWriter.key("AdditionalInfo").value(associationStatus.getAdditionalInfo());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

