/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.DirectoryConnectSettingsDescription;
import com.amazonaws.services.directory.model.DirectorySize;
import com.amazonaws.services.directory.model.DirectoryStage;
import com.amazonaws.services.directory.model.DirectoryType;
import com.amazonaws.services.directory.model.DirectoryVpcSettingsDescription;
import com.amazonaws.services.directory.model.RadiusSettings;
import com.amazonaws.services.directory.model.RadiusStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DirectoryDescription
implements Serializable,
Cloneable {
    private String directoryId;
    private String name;
    private String shortName;
    private String size;
    private String alias;
    private String accessUrl;
    private String description;
    private ListWithAutoConstructFlag<String> dnsIpAddrs;
    private String stage;
    private Date launchTime;
    private Date stageLastUpdatedDateTime;
    private String type;
    private DirectoryVpcSettingsDescription vpcSettings;
    private DirectoryConnectSettingsDescription connectSettings;
    private RadiusSettings radiusSettings;
    private String radiusStatus;
    private String stageReason;
    private Boolean ssoEnabled;

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public DirectoryDescription withDirectoryId(String directoryId) {
        this.directoryId = directoryId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DirectoryDescription withName(String name) {
        this.name = name;
        return this;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public DirectoryDescription withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public DirectoryDescription withSize(String size) {
        this.size = size;
        return this;
    }

    public void setSize(DirectorySize size) {
        this.size = size.toString();
    }

    public DirectoryDescription withSize(DirectorySize size) {
        this.size = size.toString();
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public DirectoryDescription withAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    public DirectoryDescription withAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DirectoryDescription withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getDnsIpAddrs() {
        if (this.dnsIpAddrs == null) {
            this.dnsIpAddrs = new ListWithAutoConstructFlag();
            this.dnsIpAddrs.setAutoConstruct(true);
        }
        return this.dnsIpAddrs;
    }

    public void setDnsIpAddrs(Collection<String> dnsIpAddrs) {
        if (dnsIpAddrs == null) {
            this.dnsIpAddrs = null;
            return;
        }
        ListWithAutoConstructFlag dnsIpAddrsCopy = new ListWithAutoConstructFlag(dnsIpAddrs.size());
        dnsIpAddrsCopy.addAll(dnsIpAddrs);
        this.dnsIpAddrs = dnsIpAddrsCopy;
    }

    public DirectoryDescription withDnsIpAddrs(String ... dnsIpAddrs) {
        if (this.getDnsIpAddrs() == null) {
            this.setDnsIpAddrs(new ArrayList<String>(dnsIpAddrs.length));
        }
        for (String value : dnsIpAddrs) {
            this.getDnsIpAddrs().add(value);
        }
        return this;
    }

    public DirectoryDescription withDnsIpAddrs(Collection<String> dnsIpAddrs) {
        if (dnsIpAddrs == null) {
            this.dnsIpAddrs = null;
        } else {
            ListWithAutoConstructFlag dnsIpAddrsCopy = new ListWithAutoConstructFlag(dnsIpAddrs.size());
            dnsIpAddrsCopy.addAll(dnsIpAddrs);
            this.dnsIpAddrs = dnsIpAddrsCopy;
        }
        return this;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public DirectoryDescription withStage(String stage) {
        this.stage = stage;
        return this;
    }

    public void setStage(DirectoryStage stage) {
        this.stage = stage.toString();
    }

    public DirectoryDescription withStage(DirectoryStage stage) {
        this.stage = stage.toString();
        return this;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
    }

    public DirectoryDescription withLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
        return this;
    }

    public Date getStageLastUpdatedDateTime() {
        return this.stageLastUpdatedDateTime;
    }

    public void setStageLastUpdatedDateTime(Date stageLastUpdatedDateTime) {
        this.stageLastUpdatedDateTime = stageLastUpdatedDateTime;
    }

    public DirectoryDescription withStageLastUpdatedDateTime(Date stageLastUpdatedDateTime) {
        this.stageLastUpdatedDateTime = stageLastUpdatedDateTime;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DirectoryDescription withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(DirectoryType type) {
        this.type = type.toString();
    }

    public DirectoryDescription withType(DirectoryType type) {
        this.type = type.toString();
        return this;
    }

    public DirectoryVpcSettingsDescription getVpcSettings() {
        return this.vpcSettings;
    }

    public void setVpcSettings(DirectoryVpcSettingsDescription vpcSettings) {
        this.vpcSettings = vpcSettings;
    }

    public DirectoryDescription withVpcSettings(DirectoryVpcSettingsDescription vpcSettings) {
        this.vpcSettings = vpcSettings;
        return this;
    }

    public DirectoryConnectSettingsDescription getConnectSettings() {
        return this.connectSettings;
    }

    public void setConnectSettings(DirectoryConnectSettingsDescription connectSettings) {
        this.connectSettings = connectSettings;
    }

    public DirectoryDescription withConnectSettings(DirectoryConnectSettingsDescription connectSettings) {
        this.connectSettings = connectSettings;
        return this;
    }

    public RadiusSettings getRadiusSettings() {
        return this.radiusSettings;
    }

    public void setRadiusSettings(RadiusSettings radiusSettings) {
        this.radiusSettings = radiusSettings;
    }

    public DirectoryDescription withRadiusSettings(RadiusSettings radiusSettings) {
        this.radiusSettings = radiusSettings;
        return this;
    }

    public String getRadiusStatus() {
        return this.radiusStatus;
    }

    public void setRadiusStatus(String radiusStatus) {
        this.radiusStatus = radiusStatus;
    }

    public DirectoryDescription withRadiusStatus(String radiusStatus) {
        this.radiusStatus = radiusStatus;
        return this;
    }

    public void setRadiusStatus(RadiusStatus radiusStatus) {
        this.radiusStatus = radiusStatus.toString();
    }

    public DirectoryDescription withRadiusStatus(RadiusStatus radiusStatus) {
        this.radiusStatus = radiusStatus.toString();
        return this;
    }

    public String getStageReason() {
        return this.stageReason;
    }

    public void setStageReason(String stageReason) {
        this.stageReason = stageReason;
    }

    public DirectoryDescription withStageReason(String stageReason) {
        this.stageReason = stageReason;
        return this;
    }

    public Boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public void setSsoEnabled(Boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    public DirectoryDescription withSsoEnabled(Boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
        return this;
    }

    public Boolean getSsoEnabled() {
        return this.ssoEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: " + this.getDirectoryId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getShortName() != null) {
            sb.append("ShortName: " + this.getShortName() + ",");
        }
        if (this.getSize() != null) {
            sb.append("Size: " + this.getSize() + ",");
        }
        if (this.getAlias() != null) {
            sb.append("Alias: " + this.getAlias() + ",");
        }
        if (this.getAccessUrl() != null) {
            sb.append("AccessUrl: " + this.getAccessUrl() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getDnsIpAddrs() != null) {
            sb.append("DnsIpAddrs: " + this.getDnsIpAddrs() + ",");
        }
        if (this.getStage() != null) {
            sb.append("Stage: " + this.getStage() + ",");
        }
        if (this.getLaunchTime() != null) {
            sb.append("LaunchTime: " + this.getLaunchTime() + ",");
        }
        if (this.getStageLastUpdatedDateTime() != null) {
            sb.append("StageLastUpdatedDateTime: " + this.getStageLastUpdatedDateTime() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getVpcSettings() != null) {
            sb.append("VpcSettings: " + this.getVpcSettings() + ",");
        }
        if (this.getConnectSettings() != null) {
            sb.append("ConnectSettings: " + this.getConnectSettings() + ",");
        }
        if (this.getRadiusSettings() != null) {
            sb.append("RadiusSettings: " + this.getRadiusSettings() + ",");
        }
        if (this.getRadiusStatus() != null) {
            sb.append("RadiusStatus: " + this.getRadiusStatus() + ",");
        }
        if (this.getStageReason() != null) {
            sb.append("StageReason: " + this.getStageReason() + ",");
        }
        if (this.isSsoEnabled() != null) {
            sb.append("SsoEnabled: " + this.isSsoEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getShortName() == null ? 0 : this.getShortName().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getAccessUrl() == null ? 0 : this.getAccessUrl().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDnsIpAddrs() == null ? 0 : this.getDnsIpAddrs().hashCode());
        hashCode = 31 * hashCode + (this.getStage() == null ? 0 : this.getStage().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTime() == null ? 0 : this.getLaunchTime().hashCode());
        hashCode = 31 * hashCode + (this.getStageLastUpdatedDateTime() == null ? 0 : this.getStageLastUpdatedDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSettings() == null ? 0 : this.getVpcSettings().hashCode());
        hashCode = 31 * hashCode + (this.getConnectSettings() == null ? 0 : this.getConnectSettings().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusSettings() == null ? 0 : this.getRadiusSettings().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusStatus() == null ? 0 : this.getRadiusStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStageReason() == null ? 0 : this.getStageReason().hashCode());
        hashCode = 31 * hashCode + (this.isSsoEnabled() == null ? 0 : this.isSsoEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryDescription)) {
            return false;
        }
        DirectoryDescription other = (DirectoryDescription)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getShortName() == null ^ this.getShortName() == null) {
            return false;
        }
        if (other.getShortName() != null && !other.getShortName().equals(this.getShortName())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getAccessUrl() == null ^ this.getAccessUrl() == null) {
            return false;
        }
        if (other.getAccessUrl() != null && !other.getAccessUrl().equals(this.getAccessUrl())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDnsIpAddrs() == null ^ this.getDnsIpAddrs() == null) {
            return false;
        }
        if (other.getDnsIpAddrs() != null && !other.getDnsIpAddrs().equals(this.getDnsIpAddrs())) {
            return false;
        }
        if (other.getStage() == null ^ this.getStage() == null) {
            return false;
        }
        if (other.getStage() != null && !other.getStage().equals(this.getStage())) {
            return false;
        }
        if (other.getLaunchTime() == null ^ this.getLaunchTime() == null) {
            return false;
        }
        if (other.getLaunchTime() != null && !other.getLaunchTime().equals(this.getLaunchTime())) {
            return false;
        }
        if (other.getStageLastUpdatedDateTime() == null ^ this.getStageLastUpdatedDateTime() == null) {
            return false;
        }
        if (other.getStageLastUpdatedDateTime() != null && !other.getStageLastUpdatedDateTime().equals(this.getStageLastUpdatedDateTime())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getVpcSettings() == null ^ this.getVpcSettings() == null) {
            return false;
        }
        if (other.getVpcSettings() != null && !other.getVpcSettings().equals(this.getVpcSettings())) {
            return false;
        }
        if (other.getConnectSettings() == null ^ this.getConnectSettings() == null) {
            return false;
        }
        if (other.getConnectSettings() != null && !other.getConnectSettings().equals(this.getConnectSettings())) {
            return false;
        }
        if (other.getRadiusSettings() == null ^ this.getRadiusSettings() == null) {
            return false;
        }
        if (other.getRadiusSettings() != null && !other.getRadiusSettings().equals(this.getRadiusSettings())) {
            return false;
        }
        if (other.getRadiusStatus() == null ^ this.getRadiusStatus() == null) {
            return false;
        }
        if (other.getRadiusStatus() != null && !other.getRadiusStatus().equals(this.getRadiusStatus())) {
            return false;
        }
        if (other.getStageReason() == null ^ this.getStageReason() == null) {
            return false;
        }
        if (other.getStageReason() != null && !other.getStageReason().equals(this.getStageReason())) {
            return false;
        }
        if (other.isSsoEnabled() == null ^ this.isSsoEnabled() == null) {
            return false;
        }
        return other.isSsoEnabled() == null || other.isSsoEnabled().equals(this.isSsoEnabled());
    }

    public DirectoryDescription clone() {
        try {
            return (DirectoryDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

